package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit test case for the <code>OtherSituationImpl</code> class.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 */
public class OtherSituationImplTest extends TestCase {

    /** Target instance for the tests. */
    private OtherSituation sit;

    /**
     * Constructor for OtherSituationImplTest.
     * @param testcase
     */
    public OtherSituationImplTest(String testcase) {
        super(testcase);
    }

    /**
     * Tests whether <code>toString</code> doesn't blow up.
     */
    public void testToString() {
        assertNotNull(sit.toString());
    }

    /**
     * Tests presence of attributes in the public interface
     */
    public void testInterface() {
        sit.getAny();
        sit.getReasoningScope();
        // setters show on other tests

        assertTrue(sit instanceof SituationType);
    }

    /**
     * Tests the serialization for <code>OtherSituation</code>.
     */
    public void testSerialization() {
        Util.testEObjectSerialization(sit);
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals() {
        OtherSituation sit2 = (OtherSituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit.setAny("f");
        sit.setReasoningScope("r");
        sit2 = (OtherSituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit2.setAny("difference");
        assertFalse(sit.equals(sit2));
    }

    /**
     * Tests validation for <code>OtherSituation</code>.
     */
    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(sit, "all");

        sit.setAny("a");
        sit.setReasoningScope("r");
        sit.validate();

        sit.setAny(null);
        Util.assertMissingAttributes(sit, "any");

        sit.setAny("f");
        sit.setReasoningScope(null);
        Util.assertMissingAttributes(sit, "reasoningScope");
    }

    /**
     * Tests validation for <code>OtherSituation</code>.
     */
    public void testValidationInvalidLengths() {
        sit.setAny(Util.getPaddedString(1024)); // any has no length limit
        sit.setReasoningScope(Util.getPaddedString(64));
        try {
            sit.validate();
        }
        catch (ValidationException e) {
            fail("Strings have correct length");
        }

        sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(sit, "reasoningScope");
    }

    /**
     * 
     */
    public void testAdapter() {
        Util.assertAdapterNotification(sit);
    }

    /**
     * 
     */
    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(sit);
    }

    /*
     * Protected methods.
     */

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eFx = EventFactory.eINSTANCE;
        sit = eFx.createOtherSituation();
    }

}
