/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 *  
 */
public class XMLthreadStartLoader extends TraceXMLFragmentLoader {
	//~ Instance fields
	// ----------------------------------------------------------------------------
	//    protected static final String OBJ_ID_REF = "objIdRef";
	protected static final String GROUP_NAME = "groupName";
	protected static final String PARENT_NAME = "parentName";
	protected static final String THREAD_NAME = "threadName";
	protected static final String THREAD_ID = "threadId";
	private String groupName;
	private String parentName;
	private String threadName;
	private int threadId;
	private long objIdRef;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.THREAD_ID_int :
				threadId = Integer.parseInt(value);
				break;
			case TraceConstants.THREAD_NAME_int :
				threadName = value;
				break;
			case TraceConstants.PARENT_NAME_int :
				parentName = value;
				break;
			case TraceConstants.GROUP_NAME_int :
				groupName = value;
				break;
			case TraceConstants.OBJ_ID_REF_int :
				objIdRef = Long.parseLong(value);
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		/* If we didn't get a group name */
		if (groupName == null) {
			groupName = UNKNOWN;
		}
		/* If we didn't get a parent thread name */
		if ((parentName == null) || parentName.equals("(null)")) {
			parentName = UNKNOWN;
		}
		if ((threadId != 0) && (threadName != null)) {
			TRCProcess p = getProcess();
			TRCThread thread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, LoadersUtils.getLookUpKey(threadId));
			if (thread == null) {
				thread = TraceFactory.eINSTANCE.createTRCThread();
				thread.setId(threadId);
				thread.setProcess(p);
			}
			//last update wins
			thread.setName(threadName);
			thread.setGroupName(groupName);
			thread.setStartTime(createDeltaTime());
			//            for (Iterator iter = p.getThreads().iterator(); iter.hasNext();)
			// {
			//				TRCThread t = (TRCThread) iter.next();
			//
			//                if ((t.getName() != null) && t.getName().equals(parentName)) {
			//                    thread.setParent(t);
			//
			//                    break;
			//                }
			//            }
			TRCThreadRunningEvent event = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
			event.setTime(thread.getStartTime());
			thread.getThreadEvents().add(event);
		}
	}
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		threadId = 0;
		groupName = null;
		parentName = null;
		threadName = null;
		objIdRef = 0;
	}
}