/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.resources.database.internal.dbmodel.Database;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Database</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.DatabaseImpl#getTables <em>Tables</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.DatabaseImpl#getTypes <em>Types</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DatabaseImpl extends DBElementImpl implements Database {
	/**

	 * The cached value of the '{@link #getTables() <em>Tables</em>}' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getTables()

	 * @generated

	 * @ordered

	 */

	protected EList tables = null;

	/**

	 * The cached value of the '{@link #getTypes() <em>Types</em>}' containment reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getTypes()

	 * @generated

	 * @ordered

	 */

	protected EList types = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected DatabaseImpl() {
		super();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected EClass eStaticClass() {
		return DbmodelPackage.eINSTANCE.getDatabase();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EList getTables() {
		if (tables == null) {
			tables = new EObjectContainmentEList(Table.class, this, DbmodelPackage.DATABASE__TABLES);

		}

		return tables;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EList getTypes() {
		if (types == null) {
			types = new EObjectContainmentEList(SQLType.class, this, DbmodelPackage.DATABASE__TYPES);

		}

		return types;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DbmodelPackage.DATABASE__TABLES :

					return ((InternalEList) getTables()).basicRemove(otherEnd, msgs);

				case DbmodelPackage.DATABASE__TYPES :

					return ((InternalEList) getTypes()).basicRemove(otherEnd, msgs);

				default :

					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);

			}

		}

		return eBasicSetContainer(null, featureID, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.DATABASE__NAME :

				return getName();

			case DbmodelPackage.DATABASE__TABLES :

				return getTables();

			case DbmodelPackage.DATABASE__TYPES :

				return getTypes();

		}

		return eDynamicGet(eFeature, resolve);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.DATABASE__NAME :

				setName((String) newValue);

				return;

			case DbmodelPackage.DATABASE__TABLES :

				getTables().clear();

				getTables().addAll((Collection) newValue);

				return;

			case DbmodelPackage.DATABASE__TYPES :

				getTypes().clear();

				getTypes().addAll((Collection) newValue);

				return;

		}

		eDynamicSet(eFeature, newValue);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.DATABASE__NAME :

				setName(NAME_EDEFAULT);

				return;

			case DbmodelPackage.DATABASE__TABLES :

				getTables().clear();

				return;

			case DbmodelPackage.DATABASE__TYPES :

				getTypes().clear();

				return;

		}

		eDynamicUnset(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.DATABASE__NAME :

				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);

			case DbmodelPackage.DATABASE__TABLES :

				return tables != null && !tables.isEmpty();

			case DbmodelPackage.DATABASE__TYPES :

				return types != null && !types.isEmpty();

		}

		return eDynamicIsSet(eFeature);

	}

} //DatabaseImpl

