/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.Collection;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.ReferenceQuery;
/**
 * This class implements the ReferenceQuery interface.
 */
public class ReferenceQueryImpl implements ReferenceQuery {
	protected EObject object;
	protected EReference reference;
	protected int lower;
	protected int upper;
	protected boolean setReferences;
	protected Collection notLoadedClasses;

	/**
	 * Constructor for ReferenceQueryImpl.
	 */
	public ReferenceQueryImpl() {
		super();
		lower = 0;
		upper = -1;
		setReferences = true;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#getEObject()
	 */
	public EObject getEObject() {
		return object;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#setEObject(EObject)
	 */
	public void setEObject(EObject object) {
		this.object = object;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#getEReference()
	 */
	public EReference getEReference() {
		return reference;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#setEReference(EReference)
	 */
	public void setEReference(EReference reference) {
		this.reference = reference;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#getLower()
	 */
	public int getLower() {
		return lower;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#setLower(int)
	 */
	public void setLower(int lower) {
		this.lower = lower;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#getUpper()
	 */
	public int getUpper() {
		return upper;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#setUpper(int)
	 */
	public void setUpper(int upper) {
		this.upper = upper;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#isSetReferences()
	 */
	public boolean isSetReferences() {
		return setReferences;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#setReferences(boolean)
	 */
	public void setReferences(boolean setReferences) {
		this.setReferences = setReferences;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#setNotLoadedClasses(java.util.Collection)
	 */
	public void setNotLoadedClasses(Collection classes) {
		notLoadedClasses = classes;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ReferenceQuery#getNotLoadedClasses()
	 */
	public Collection getNotLoadedClasses() {
		return notLoadedClasses;
	}
} // ReferenceQueryImpl
