package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The RequestSituation deals with the situations that a component uses to identify 
 * the completion status of a request. Typically, these requests are complex management 
 * tasks or transactions that a component undertakes on behalf of a requestor and not 
 * the mainline simple requests or transactions. Existing messages include words like 
 * configuration synchronization started, and backup procedure complete, for example:
 * 
 * <code>
 * ADMS0003I: Configuration synchronization completed
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IRequestSituation extends ISituationType {

    /**
     * Returns the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a 
     * situation that caused the situation to be reported.  The successDisposition 
     * is a string with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned successDisposition.
     * @since 1.0.1
     */
    public String getSuccessDisposition();

	/**
	 * Returns the situationQualifier.
	 * 
	 * This property specifies the request qualifiers that are representation of 
	 * the parameters necessary to describe the  situation.  The situationQualifier 
	 * is a string with the following set of values:
	 * 
	 * REQUEST INITIATED
	 * REQUEST COMPLETED
	 * 
	 * This is a REQUIRED property and once it is set it MUST NOT change. 
	 * The string length for this property MUST NOT exceed 64 characters.
	 * 
	 * @return String The returned situationQualifier.
	 * @since 1.0.1
	 */
	public String getSituationQualifier();

    /**
     * Sets the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a 
     * situation that caused the situation to be reported.  The successDisposition 
     * is a string with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param successDisposition The successDisposition to be set.
     * @since 1.0.1
     */
    public void setSuccessDisposition(String successDisposition);

	/**
	 * Sets the situationQualifier.
	 * 
	 * This property specifies the request qualifiers that are representation of 
	 * the parameters necessary to describe the  situation.  The situationQualifier 
	 * is a string with the following set of values:
	 * 
	 * REQUEST INITIATED
	 * REQUEST COMPLETED
	 * 
	 * This is a REQUIRED property and once it is set it MUST NOT change. 
	 * The string length for this property MUST NOT exceed 64 characters.
	 * 
	 * @param situationQualifier The situationQualifier to be set.
	 * @since 1.0.1
	 */
	public void setSituationQualifier(String situationQualifier);
}
