/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.help.*;

public class LogAnalyzerSortPrefPage implements SelectionListener{

	private CBESortUI _options;
	private IPreferenceStore _preferenceStore;
	private boolean sortHasChanged = false;

	public LogAnalyzerSortPrefPage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		GridData data = GridUtil.createFill();
		composite.setLayoutData(data);

		_options = new CBESortUI();
		_options.createControl(composite);
		_options.addListener(this);		

		initializeValues();

		WorkbenchHelp.setHelp(composite, ContextIds.ACTLOG_PREF_SORT_RECORDS);

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return LogUIPlugin.getDefault().getPreferenceStore();
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {

		_options.initializeValues(true);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {

		_options.initializeValues(false);
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		_options.removeListener(this);		
		LogUIPlugin.getDefault().savePluginPreferences();
		if(sortHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.SORT_COL_CHANGE, this));
		}		
		sortHasChanged = false;		
		return true;
	}
	
	public void performApply(){
		_options.applyValues(_preferenceStore);
		LogUIPlugin.getDefault().savePluginPreferences();
		if(sortHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.SORT_COL_CHANGE, this));
		}
		sortHasChanged = false;
				
	}
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */

	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {

		if(e.data!=null && e.data instanceof Integer && ((Integer)e.data).intValue()==RecordChangeEvent.SORT_COL_CHANGE ){
			sortHasChanged = true;
		}

	}

	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		_options.storeValues(_preferenceStore);
	}
}