/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.hyades.statistical.ui.*;

import org.eclipse.emf.common.util.*;

import org.eclipse.hyades.model.statistical.impl.*;

import org.eclipse.swt.graphics.*;

public abstract class SDGenericVariable extends SDRepresentationImpl {

	private static final boolean DEBUG = false;

	protected Image image;
	protected String uid;
	protected String name;
	protected String description;
	protected boolean has_bar;

	protected SDGenericVariable(String uid, String name, String description, Image image, boolean has_bar) {
		this.uid = uid;
		this.name = name;
		this.description = description;
		this.image = image;
		this.has_bar = has_bar;
	}

	public String getUniqueID() {
		return uid;	
	}
	
	public String getName() {
		return name;	
	}
	
	public String getDescription() {
		return description;	
	}
	
	public Image getImage() {
		return image;	
	}
	
	public boolean hasBar() {
		return has_bar;	
	}

	protected void addValue(BasicEList times, BasicEList values, long t, Object d) {
if (DEBUG) EditorPlugin.DBG.info("Add VALUE");

		if (times.size() > 0) {
			//
			//append
			//
			if (t > ((Double)times.get(times.size()-1)).longValue()) {
				times.addUnique(new Double(t));
				values.addUnique(d);		

				if (DEBUG) EditorPlugin.DBG.info("Adding unique "+t+" to "+((Double)times.get(times.size()-1)).longValue());
				
				return;
			}
//		} else {
//
//			times.addUnique(new Double(t));
//			values.addUnique(d);		
//
//			System.out.println("Adding unique "+t+" to "+((Double)times.get(times.size()-1)).longValue());
//
//			return;
//							
		}

		for (int i = times.size()-1; i >= 0; i--) {
			long pt = ((Double)times.get(i)).longValue();	
			
			//
			// overwrite (same timestamp)
			//
			if (pt == t) {
//				values.remove(i);
				values.setUnique(i,d);

				if (DEBUG) EditorPlugin.DBG.info("Overwriting unique "+t+" to "+pt+" ("+i+")");
				
				return;

			//
			// insert (old timestamp)
			// NB: PERHAPS THIS SHOULD BE WEIGHTED BINARY CHOP?
			//				
			} else if (pt < t) {
				i++;
				times.addUnique(i,new Double(t));
				values.addUnique(i,d);

				if (DEBUG) EditorPlugin.DBG.info("Overwriting unique "+t+" to "+pt+" ("+i+")");
				
				return;
				
			}
		}

		if (DEBUG) EditorPlugin.DBG.info("Adding at 0 "+t);

		times.addUnique(0,new Double(t));
		values.addUnique(0,d);

		return;

	}
	
	
}