package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * Signals that the XML data cannot be processed by the consuming widget.
 * 
 * This exception will be raised when the widget request to retrieve
 * the required data from the XML <code>Document</code> object fails.
 * An error code is provided for, along with the tag name of the problem
 * XML element and the widget type consuming the data. 
 * 
 * @version 1.13.1.1
 * 
 * @see IDataInputProcessingExceptionCodes
 * @see IGraphicDocumentGenerator 
 */
public class DataInputProcessingException extends Exception {
	private int errorCode = 0;
	private String sourceElement = null;
	private String widgetType = null;
	
	/**
	 * Default constructor.
	 */
	public DataInputProcessingException() { }
	
	/**
	 * Constructs a <code>DataInputProcessingException</code> with the
	 * specified detail message.
	 * 
	 * @param msg a message providing information about the exception.
	 * @param element the tag name of the data <code>Element</code>
	 */
	public DataInputProcessingException(String msg, String element) { 
		super(msg);
		this.sourceElement = element;
		
	}
	
	/**
	 * Constructs a <code>DataInputProcessingException</code> with the
	 * specified error code and the data element tag name.
	 * 
	 * @param error one of the documented error codes.
	 * @param element the tag name of the data <code>Element</code>
	 */
	public DataInputProcessingException(int error, String element) {
		this.errorCode = error;
		this.sourceElement = element;		
	}
	/**
	 * Constructs a <code>DataInputProcessingException</code> with the
	 * specified detail message, the error code and the data element tag
	 * name.
	 * 
	 * @param msg a message providing information about the exception.
	 * @param error one of the documented error codes
	 * @param element the tag name of the data <code>Element</code>
	 */
	public DataInputProcessingException(String msg, int error, String element) {
		super(msg);
		this.errorCode = error;
		this.sourceElement = element;		
	}
	
	/**
	 * Constructs a <code>DataInputProcessingException</code> with the
	 * specified detail message, the error code, the data element tag 
	 * name and the widget type.
	 * 
	 * @param msg a message providing information about the exception.
	 * @param error one of the documented error codes
	 * @param element the tag name of the data <code>Element</code>
	 * @param type the graphic type produced by the object throwing the exception  
	 */
	public DataInputProcessingException(String msg, int error, String element, String type) {
		super(msg);
		this.errorCode = error;
		this.sourceElement = element;
		this.widgetType = type;
	}
	
	/**
	 * Returns the error code which was passed as constructor parameter. 
	 */		
	public int getErrorCode() {
		return errorCode;
	}
		
	/**
	 * Returns the element which was passed as constructor parameter. 
	 */
	public String getElement() {
		return sourceElement;
	}
		
	/**
	 * Returns the graphic type which was passed as constructor parameter. 
	 */
	public String getWidgetType() {
		return widgetType;
	}	
	
	/**
	 * Sets the graphic type produced by the object throwing the exception.
	 * 
	 * @param type the type of graphic 
	 */
	public void setWidgetType(String type) {
		this.widgetType = type;
	}			
}	

