/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

import org.eclipse.hyades.models.common.configuration.CFGClass;

import org.eclipse.hyades.models.common.datapool.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage
 * @generated
 */
public class Common_DatapoolSwitch {
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static Common_DatapoolPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Common_DatapoolSwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = Common_DatapoolPackage.eINSTANCE;
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	public Object doSwitch(EObject theEObject)
    {
        EClass theEClass = theEObject.eClass();
        if (theEClass.eContainer() == modelPackage)
        {
            switch (theEClass.getClassifierID())
            {
                case Common_DatapoolPackage.DPL_DATAPOOL_SPEC:
                {
                    DPLDatapoolSpec dplDatapoolSpec = (DPLDatapoolSpec)theEObject;
                    Object result = caseDPLDatapoolSpec(dplDatapoolSpec);
                    if (result == null) result = caseCMNNamedElement(dplDatapoolSpec);
                    if (result == null) result = defaultCase(theEObject);
                    return result;
                }
                case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS:
                {
                    DPLEquivalenceClass dplEquivalenceClass = (DPLEquivalenceClass)theEObject;
                    Object result = caseDPLEquivalenceClass(dplEquivalenceClass);
                    if (result == null) result = caseCMNNamedElement(dplEquivalenceClass);
                    if (result == null) result = defaultCase(theEObject);
                    return result;
                }
                case Common_DatapoolPackage.DPL_RECORD:
                {
                    DPLRecord dplRecord = (DPLRecord)theEObject;
                    Object result = caseDPLRecord(dplRecord);
                    if (result == null) result = defaultCase(theEObject);
                    return result;
                }
                case Common_DatapoolPackage.DPL_CELL:
                {
                    DPLCell dplCell = (DPLCell)theEObject;
                    Object result = caseDPLCell(dplCell);
                    if (result == null) result = defaultCase(theEObject);
                    return result;
                }
                case Common_DatapoolPackage.DPL_VARIABLE:
                {
                    DPLVariable dplVariable = (DPLVariable)theEObject;
                    Object result = caseDPLVariable(dplVariable);
                    if (result == null) result = caseCMNNamedElement(dplVariable);
                    if (result == null) result = defaultCase(theEObject);
                    return result;
                }
                case Common_DatapoolPackage.DPL_DATAPOOL:
                {
                    DPLDatapool dplDatapool = (DPLDatapool)theEObject;
                    Object result = caseDPLDatapool(dplDatapool);
                    if (result == null) result = caseCFGClass(dplDatapool);
                    if (result == null) result = caseCMNNamedElement(dplDatapool);
                    if (result == null) result = defaultCase(theEObject);
                    return result;
                }
                default: return defaultCase(theEObject);
            }
        }
        return defaultCase(theEObject);
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>DPL Datapool Spec</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>DPL Datapool Spec</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseDPLDatapoolSpec(DPLDatapoolSpec object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>DPL Datapool</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>DPL Datapool</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseDPLDatapool(DPLDatapool object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>DPL Equivalence Class</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>DPL Equivalence Class</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseDPLEquivalenceClass(DPLEquivalenceClass object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>DPL Record</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>DPL Record</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseDPLRecord(DPLRecord object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>DPL Cell</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>DPL Cell</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseDPLCell(DPLCell object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>DPL Variable</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>DPL Variable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseDPLVariable(DPLVariable object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>CMN Named Element</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>CMN Named Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseCMNNamedElement(CMNNamedElement object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>CFG Class</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>CFG Class</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public Object caseCFGClass(CFGClass object)
    {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	public Object defaultCase(EObject object)
    {
        return null;
    }

} //Common_DatapoolSwitch
