/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.model.util;

import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.InvocationEvent;
import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;

/**
 * @author marcelop
 * @since 1.0.2
 */
public abstract class EventLogger
{	
	public void logMessage(NamedElement namedElement, int messageSeverity, String text)
	{
		if(namedElement == null)
			return;
			
		MessageEvent event = new MessageEvent();
		event.setOwnerId(ModelUtil.getHierarchyId(namedElement));
		event.setText(text);
		event.setSeverity(messageSeverity);
		
		log(event);
	}

	public void logTyped(NamedElement namedElement, int type, String text)
	{
		if(namedElement == null)
			return;
			
		TypedEvent event = new TypedEvent();
		event.setOwnerId(ModelUtil.getHierarchyId(namedElement));
		event.setText(text);
		event.setType(type);
		
		log(event);
	}

	public void logInvocation(TestInvocation testInvocation, int status, String text)
	{
		if(testInvocation == null)
			return;
			
		InvocationEvent event = new InvocationEvent();
		event.setOwnerId(ModelUtil.getHierarchyId(testInvocation));
		event.setText(text);
		
		if(testInvocation.getTest() == null)
		{
			event.setStatus(InvocationEvent.STATUS_UNSUCCESSFUL);
			event.setReason(InvocationEvent.REASON_NO_BEHAVIOR);
		}
		else
		{
			event.setInvokedId(ModelUtil.appendHierarchyId(testInvocation.getTest(), event.getOwnerId()));
			event.setStatus(status);
		}
		
		log(event);
	}
	
	abstract public void log(ExecutionEvent executionEvent);
}