/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility.TestGenUIException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * wizard page which prompts the user for the test generator to use in generating a test
 * @author Ernest Jessee
 */
public class TestGeneratorSelectorPage extends WizardPage implements ITestGenWizardPage
{
	
	private Combo generatorsCombo;



	public TestGeneratorSelectorPage()
	{
		super(TestGeneratorSelectorPage.class.getName());
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.testgen.ui.wizards.ITestGenWizardPage#getContextHelpID()
	 */
	public String getContextHelpID()
	{
		return "org.eclipse.hyades.execution.testgen.GeneratorSelectorPage"; //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.testgen.ui.wizards.ITestGenWizardPage#saveSettings()
	 */
	public void saveSettings()
	{
			//DO NOT SAVE SETTINGS, ALWAYS USE DEFAULT GENERATOR
			
			//String ID = TestGeneratorFactory.getInstance().getGeneratorIDByIndex(generatorsCombo.getSelectionIndex());
			//TestgenPlugin.getDefault().getPreferenceStore().setValue(TestgenPlugin.SELECTED_GENERATOR,ID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite grandParent)
	{
		setTitle(TestgenPlugin.getResourceString("TEST_GENERATION_WIZARD_TITLE")); //$NON-NLS-1$
		setDescription(TestgenPlugin.getResourceString("TEST_GENERATION_SELECT_GENERATOR_WIZARDPAGE_DESCRIPTION")); //$NON-NLS-1$
		Composite parent = new Composite(grandParent,SWT.NULL);
		WorkbenchHelp.setHelp(parent,getContextHelpID());
		TestgenUIUtility.assignGridLayout(parent,2);
		Label label = TestgenUIUtility.createLabel(parent,TestgenPlugin.getResourceString("TEST_GENERATOR_SELECTION_LABEL"),null); //$NON-NLS-1$
		generatorsCombo = new Combo(parent,SWT.READ_ONLY|SWT.DROP_DOWN);
		
		String generatorIDs[] = TestGeneratorFactory.getInstance().getGeneratorIDs();
		String selectedID = TestgenPlugin.getDefault().getPreferenceStore().getString(TestgenPlugin.TEST_GENERATOR);
		for(int i=0; i<generatorIDs.length; i++)
		{
			String id = generatorIDs[i];
			generatorsCombo.add(TestGeneratorFactory.getInstance().getGeneratorName(id));
			if(id.equalsIgnoreCase(selectedID))
				generatorsCombo.select(i);
		}
		
		
		
		try
		{
			TestgenUIUtility.layoutControlInGrid(label,1,GridData.HORIZONTAL_ALIGN_BEGINNING);
			TestgenUIUtility.layoutControlInGrid(generatorsCombo,1,GridData.GRAB_HORIZONTAL|GridData.HORIZONTAL_ALIGN_FILL);
			
		}
		catch (TestGenUIException e)
		{
			e.printStackTrace();
		}
		
		
		setControl(parent);
		
		

	}

	public String getSelectedGeneratorID()
	{
		return TestGeneratorFactory.getInstance().getGeneratorIDByIndex(generatorsCombo.getSelectionIndex());		
	}
}
