/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/**
 * 
 * @author ewchan
 *
 * The is the action contributed to the LogGraphNode of log interactions
 * User can open the selected CBE Event of UML2SD log interaction view in Log View
 */
public class OpenLogView implements IObjectActionDelegate {

	private SDView view;
	private CorrelationContainerProxy proxy;
	private EObject cbeEvent;

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		openView();
	}
	
	private void openView() {
		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
            EObject mofObject = HyadesUtil.getObjectToView(HyadesUtil.getMofObject());
            if (mofObject==null) {
            	selectCorrelationProxyInNavigator();
            	mofObject = proxy;
            } 
			TraceViewer view = (LogViewer) (persp.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer"));
			if (view != null)	{				
				view.addViewPage(mofObject);
				((LogViewer)view).getLogPage().getView().revealObject(cbeEvent);
				LogUtil.notifyViewSelectionChanged(((LogViewer)view).getLogPage().getView(),cbeEvent);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection != null && ((IStructuredSelection)selection).getFirstElement() instanceof LogGraphNode) {
			LogGraphNode sel = (LogGraphNode)((IStructuredSelection)selection).getFirstElement();
			if(sel!=null){
				if(sel.hasElements()){
					cbeEvent = (EObject)sel.getElements().get(0);
				}else{
					cbeEvent = sel.getElement();
				}
			}
			
		}
		else
		{
			cbeEvent = null;
		}
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		if (targetPart!=null && targetPart instanceof SDView) {
			LogInteractions loader = ((LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader());
			proxy = loader.getCorrelationContainerProxy();
		}
		else {
			proxy = null;
		}
	}
	
	public void selectCorrelationProxyInNavigator() {
		if (proxy!=null) {
			LogUtil.selectInLogNavigator(proxy);
			if (cbeEvent!=null)	UIPlugin.getDefault().getSelectionModel(proxy).add(cbeEvent);
		}				
	}

}
