/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;

/**
 * It is the UML2 stop graphcal representation in the sequence diagram viewer.<br>
 * This draw a cross on the lifeline. The stop y coordinate depend on the event occurrence when it appears.<br>
 * A stop is never drawn it is assigned to a lifeline.<br>
 * <br>
 * 
 * @see org.eclipse.hyades.uml2sd.ui.core.Lifeline#setStop(Stop)
 * @author sveyrier
 *
 */
public class Stop extends GraphNode{
	
	/**
	 * The owing lifeline on which the stop appears
	 */
	protected Lifeline	lifeline		= null;
	
	/**
	 * This basicaly represents the time when the stop occurs on the owning Lifeline
	 * @see Lifeline Lifeline for more event occurence details
	 */
	protected int eventOccurrence = 0;

	public int getX()
	{
		if (lifeline==null)
			return 0;
		return lifeline.getX() + Metrics.getLifelineWidth()/2 - Metrics.STOP_WIDTH/2;
	}

	public int getY()
	{
		if (lifeline==null)
			return 0;
		return lifeline.getY() + lifeline.getHeight() + 
				(Metrics.getMessageFontHeigth()+Metrics.getMessagesSpacing()) * 
				eventOccurrence  - Metrics.STOP_WIDTH/2;
	}

	public int getWidth()
	{
		if (lifeline==null)
			return 0;
		return Metrics.STOP_WIDTH;
	}

	public int getHeight()
	{
		if (lifeline==null)
			return 0;
		return Metrics.STOP_WIDTH;
	}	
	
	/**
	 * Set the lifeline on which the stop must be draw
	 * @param theLifeline The the stop owing lifeline
	 */
	protected void setLifeline (Lifeline theLifeline)
	{
		lifeline = theLifeline;
	}

	/**
	 * Set the event occurence when this stop appears
	 * @param occurrence the eventOccurence to assign to the stop
	 */
	public void setEventOccurrence (int occurrence)
	{
		eventOccurrence = occurrence;
	}
	
	public void draw (IGC context)
	{
		//Set the appropriate color depending if the graph node if selected or not
		if (lifeline.isSelected())
		{
			context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
			context.setLineWidth(Metrics.SELECTION_LINE_WIDTH);
			int lastWidth = context.getLineWidth();
			context.setLineWidth(9);
			//Draw a cross on the lifeline
			context.drawLine(getX(), getY(), getX() + getWidth(), getY() + getHeight());
			context.drawLine( getX() + getWidth(), getY(), getX() , getY() + getHeight());
			//restore the context
			context.setLineWidth(lastWidth);
			context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
			context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
		}
		else 
		{
			context.setBackground(Frame.getUserPref().getBackGroundColor(ISDPreferences.PREF_LIFELINE));
			context.setForeground(Frame.getUserPref().getForeGroundColor(ISDPreferences.PREF_LIFELINE));
		}
		int lastWidth = context.getLineWidth();
		context.setLineWidth(3);
		//Draw a cross on the lifeline
		context.drawLine(getX(), getY(), getX() + getWidth(), getY() + getHeight());
		context.drawLine( getX() + getWidth(), getY(), getX() , getY() + getHeight());
		//restore the context
		context.setLineWidth(lastWidth);
	}
}
