/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;


/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TRCElement
{
	public class TRCAttribute
	{
		public String name;
		public String value;
		
		public TRCAttribute (String name, String value)
		{
			this.name = name;
			this.value = value;
		}
	}
	
	private String			name;		
	private TRCAttribute []	attributes;
	private int				attributeCount;
	private StringBuffer	contentBuffer;
	private TRCNode			node;
	
	public TRCElement (int nAttributes)
	{
		attributes = new TRCAttribute[nAttributes];
	}
	
	public void setName (String name)
	{
		this.name = name;
	}
	
	public String getName ()
	{
		return this.name;
	}

	public void addAttribute (String name, String value)
	{
		attributes[attributeCount++] = new TRCElement.TRCAttribute(name, value);	
	}
	
	public TRCAttribute [] getAttributes ()
	{
		return this.attributes;
	}
	
	public void setContent (String content)
	{
		if (contentBuffer == null)
			contentBuffer = new StringBuffer();
		contentBuffer.append(content);
	}
	
	public String getContent ()
	{
		return contentBuffer.toString();
	}
	
	public void setNode (TRCNode node)
	{
		this.node = node;
	}
	
	public TRCNode getNode ()
	{
		return this.node;
	}
		
}
