/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderRegistryInfo;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.jface.dialogs.MessageDialog;

/**
 * Wizard which launches the HttpProxyRecorder
 * @see org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard
 * @author Ernest Jessee
 */
public class HttpRecorderLaunchWizard extends RecorderWizard
{

	private HttpRecorderFileSelectPage fileSelectPage;
	private HttpRecorderNoProjectsPage newProjectPage;

	//private TestSuiteLocationSelectionPage testLocationPage;

	private boolean hasNoProjects = false; 

	protected boolean verifyRecorderData()
	{
		//checks if .rec or .testsuite file exist, if so will prompt to overwrite & continue.
		if (hasNoProjects)  //will never duplicate file
			return true;
		String recName = fileSelectPage.getSelectedFilePath();
		int n = recName.lastIndexOf(".rec");
		if (n == -1)
			n = recName.length();
		String tsName = recName.substring(0, recName.lastIndexOf(".rec")) + ".testsuite";

		IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(recName));
		boolean bRec = file.exists();
		boolean bTS = false;
		if (!TestgenPlugin.getPreference(TestgenPlugin.TEST_GENERATOR).equals("-1"))
		{ //only bother verifying .testsuite if it will automatically generate
			 file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(tsName));
			 bTS = file.exists();
		}
		if(bRec && bTS)
		{
			return MessageDialog.openConfirm(getWorkbench().getActiveWorkbenchWindow().getShell(), HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"),
					HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.BOTH_EXIST")
					);
		}
		else if (bRec)
		{			
			return MessageDialog.openConfirm(getWorkbench().getActiveWorkbenchWindow().getShell(), HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"),
					HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.REC_EXISTS")
					);
		}
		else if (bTS)
		{
			return MessageDialog.openConfirm(getWorkbench().getActiveWorkbenchWindow().getShell(), HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.FILES_EXIST_TITLE"),
					HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.TESTSUITE_EXISTS")
					);
		}
		return true;
	}
	
	public void run() 
	{	
		if(RecorderFactory.getInstance().getActiveRecorder()!=null)
		{
			RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR")), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_ERROR"));  //$NON-NLS-1$
			return;
		}
		
				
		Recorder recorder=null;
				
		try
		{
			recorder = HttpRecorderPlugin.getDefault().getRecorder();

			String recorderParams = "port,"+HttpRecorderPlugin.getPreference(HttpRecorderPlugin.PROXY_PORT); //$NON-NLS-1$			

			//TODO Now read the registry Info mdd hyades 1.3
			String adapterID = HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER);
			if (!(adapterID.equalsIgnoreCase("-1"))) {
				RecorderRegistryInfo regInfo = new RecorderRegistryInfo();
				handleInvalidProxySettings(regInfo);
				if (regInfo.isProxyEnabled()) {
					recorderParams = recorderParams + ";proxyInfo," + regInfo.getProxyType()+"=" 
						+ regInfo.getProxyAddr() + ":" + regInfo.getProxyPort();
				} else {
					recorderParams += ";proxyInfo,socks";
				}
			}
			else 
				recorderParams += ";proxyInfo,socks";

			//TODO Need better place for testkeys file 
			//copy testkeys from pluginroot to c:\ if not present 
			URL resolvedTestkeys = Platform.resolve(new URL(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL(), "testkeys"));
			String keyfile = resolvedTestkeys.toString(); 
			if (resolvedTestkeys.getProtocol().equals("file"))
			{
				keyfile = resolvedTestkeys.getFile();
			}
			File  sslfile = new File(keyfile);
			if (sslfile.exists())
			{
				recorderParams += ";sslkeyfile," + sslfile.getAbsolutePath();
			}
			
			String appParams = recorderParams + ";startupURL,"+getStartupURL();			
			recorder.setApplicationAdapterID(adapterID);

			if (!(adapterID.equalsIgnoreCase("-1")))
				RecorderAppAdapterFactory.getInstance().getClient(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER)).setInitString(appParams);			

			
			String recordingFileName;
			if (hasNoProjects)
			{
				IProject project = newProjectPage.createJavaProject(monitor);								
				//rec file is based within this file
				if (project != null)
					recordingFileName = project.getFullPath().toString() + "/" + newProjectPage.getRecFile();
				else
					throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.JAVA_PROJECT_NOT_CREATED_ERROR"));					
			}
			else
				recordingFileName = fileSelectPage.getSelectedFilePath();
			
			//assign testsuite name from the recording file name - simplify wizards 			
			String generatorFileName = recordingFileName.substring(0, recordingFileName.lastIndexOf('.')) + ".testsuite";

			HttpRecorderPlugin.storePreference(HttpRecorderPlugin.RECORDING_PATH,recordingFileName);			
			recorder.setConfigParams(recorderParams);
			recorder.setRecordingPath(recordingFileName);
			
			recorder.setScriptgenID(TestgenPlugin.getPreference(TestgenPlugin.TEST_GENERATOR));
			recorder.setTestPath(generatorFileName);

			//TODO Need better place for testkeys file 
			//copy testkeys from pluginroot to c:\ if not present 
/*			URL resolvedTestkeys = Platform.resolve(new URL(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL(), "testkeys"));
			String keyfile = resolvedTestkeys.toString(); 
			
			
			if (resolvedTestkeys.getProtocol().equals("file"))
			{
				keyfile = resolvedTestkeys.getFile();
			}
			File file = new File(keyfile);
			if (file.exists())
			{
				File destFile = new File("C:\\testkeys");
				if (destFile.createNewFile()) //only creates if no file exists
				{
					try {
						FileOutputStream out = new FileOutputStream(destFile);
						FileInputStream in = new FileInputStream(file);
						byte[] read = new byte[256];
						int nLen;
						while ((nLen = in.read(read)) != -1)
						{						
							out.write(read, 0, nLen);
						}
						out.flush();
						out.close();
						in.close();
					}
					catch (IOException ioe) {}
				}
			}
*/
			recorder.Record();
		}
		catch (Exception e)
		{
			if(recorder!=null)	
				recorder.setActive(false);
			e.printStackTrace();
			RecorderControlView.getInstance().addMessage(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE")+e.getMessage()); //$NON-NLS-1$
		} 
		
		
		
	}	

	/**
	 * @param regInfo
	 * @throws RecorderException
	 */
	private void handleInvalidProxySettings(RecorderRegistryInfo regInfo) throws RecorderException {
		if (regInfo.isBadProxySettings()){
			int thisProxyError = regInfo.getProxyError();
			if (thisProxyError == regInfo.SOCKS_SET){
				RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR")), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));  //$NON-NLS-1$
				throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SOCKS_ONLY_ERROR"));					
			}
			else if (thisProxyError == regInfo.HTTP_PROXY_ONLY_SET) {
				RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR")), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));  //$NON-NLS-1$
				//RecorderPlugin.reportExceptionToUser(new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR")),"","","");
				throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_PROXY_ONLY_ERROR"));
			}
			else if (thisProxyError == regInfo.SECURE_PROXY_ONLY_SET){
				RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR")), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));  //$NON-NLS-1$
				//RecorderPlugin.reportExceptionToUser(new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR")),"","","");
				throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.SECURE_PROXY_ONLY_ERROR"));
			}
			else if (thisProxyError == regInfo.HTTP_SECURE_MISMATCH){
				RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR")), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));  //$NON-NLS-1$
				//RecorderPlugin.reportExceptionToUser(new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH")),"","","");
				throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.HTTP_SECURE_MISMATCH_ERROR"));
			}
			else if (thisProxyError == regInfo.HTTP_SECURE_LOCALHOST){
				RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.LOCALHOST_ERROR")), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"), //$NON-NLS-1$
						HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_REGISTRY_ERROR"));  //$NON-NLS-1$
				throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.LOCALHOST_ERROR"));					
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		setWindowTitle(HttpRecorderPlugin.getResourceString("NAME"));
		IProject[] projects = org.eclipse.core.resources.ResourcesPlugin.getWorkspace()
							.getRoot().getProjects();
		//62169 - only count open projects
		boolean openProjExists = false; int i = 0;
		while (!openProjExists && i< projects.length)
		{
			if (projects[i].isOpen())
			{
				openProjExists = true;
			}
			i++;
		}
		if (!openProjExists)
		{
			hasNoProjects = true;
			addPage(newProjectPage = new HttpRecorderNoProjectsPage(HttpRecorderNoProjectsPage.class.getName()));
			newProjectPage.setInitialProjectName(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.DEFAULT_PROJECT_NAME"));
		}
		else
		{
			addPage(fileSelectPage = new HttpRecorderFileSelectPage());		
		}
		//if(!HttpRecorderPlugin.getPreference(HttpRecorderPlugin.TEST_GENERATOR).equalsIgnoreCase("-1")) //$NON-NLS-1$
		//	addPage(testLocationPage = new TestSuiteLocationSelectionPage());
	}

	protected String getStartupURL() throws IOException
	{
		//temp JN
		//TODO Need better place for testkeys file 
		//copy testkeys from pluginroot to c:\ if not present
		String startupURLroot = "readme";
		String HTML = ".html"; 
		URL startupURL = Platform.resolve(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL());
		String strInstall = null; 
		if (startupURL.getProtocol().equals("file"))
		{
			strInstall = startupURL.getFile() + startupURLroot;
		}
		String strLocalizedFile = strInstall + "_" + Locale.getDefault().toString() + HTML;
		File file = new File(strLocalizedFile);
		if (!file.exists())
		{
			strLocalizedFile = strInstall + "_" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + HTML;
			file = new File(strLocalizedFile);
			if (!file.exists())
			{
				strLocalizedFile = strInstall + "_" + Locale.getDefault().getLanguage() + HTML;
				file = new File(strLocalizedFile);
				if (!file.exists())
				{
					strLocalizedFile = strInstall + HTML;
					file = new File(strLocalizedFile);
					if (!file.exists())
						return "about:blank";
				}				
			}  
		}		
		return "file://" + strLocalizedFile;
	}

}

