/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;

public class ExecutionResourceChangeUpdater
implements IResourceChangeUpdater {
    private ExecutionNavigator executionNavigator;
    private List addedObjects;
    private List removedObjects;
    private List changedObjects;
    private List resourcesToSave;
    private Object[] expandedElements;
    private Object[] selectedElements;
    private boolean active;

    public ExecutionResourceChangeUpdater(ExecutionNavigator executionNavigator) {
        this.executionNavigator = executionNavigator;
        this.active = true;
    }

    public void dispose() {
        this.executionNavigator = null;
    }

    public void started() {
        this.addedObjects = new UniqueEList();
        this.removedObjects = new UniqueEList();
        this.changedObjects = new UniqueEList();
        this.resourcesToSave = new UniqueEList();
    }

    public void ended() {
        Iterator i;
        if (!this.addedObjects.isEmpty()) {
            i = this.addedObjects.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                Object parent = ((ITreeContentProvider)this.executionNavigator.getViewer().getContentProvider()).getParent(object);
                if (parent == null) {
                    this.executionNavigator.getTreeViewer().refresh(true);
                    return;
                }
                this.executionNavigator.getTreeViewer().add(parent, object);
            }
        }
        if (!this.removedObjects.isEmpty()) {
            this.executionNavigator.getTreeViewer().remove(this.removedObjects.toArray());
        }
        if (!this.changedObjects.isEmpty()) {
            i = this.changedObjects.iterator();
            while (i.hasNext()) {
                this.executionNavigator.getTreeViewer().refresh(i.next(), true);
            }
        }
        if (!this.resourcesToSave.isEmpty()) {
            i = this.resourcesToSave.iterator();
            while (i.hasNext()) {
                try {
                    EMFUtil.save((Resource)i.next());
                }
                catch (Exception e) {}
            }
        }
        ArrayList objectsToSelect = new ArrayList();
        Iterator i2 = this.addedObjects.iterator();
        while (i2.hasNext()) {
            IFile file;
            Object object = i2.next();
            if (!(object instanceof TPFExecutionResult)) continue;
            objectsToSelect.add(object);
            if (!TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor") || (file = EMFUtil.getWorkspaceFile((EObject)((TPFExecutionResult)object))) == null || !file.exists()) continue;
            UIUtil.openEditor((IFile)file, (String)"org.eclipse.hyades.test.ui.editor.ExecutionEditorPart", (boolean)false);
        }
        if (this.expandedElements != null) {
            this.convertURIToEObject(this.expandedElements);
            this.executionNavigator.getTreeViewer().setExpandedElements(this.expandedElements);
            if (objectsToSelect.isEmpty()) {
                this.convertURIToEObject(this.selectedElements);
                this.executionNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.selectedElements), true);
            }
            this.expandedElements = null;
            this.selectedElements = null;
        }
        if (!objectsToSelect.isEmpty()) {
            this.executionNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection(objectsToSelect), true);
            objectsToSelect.clear();
        }
        this.addedObjects.clear();
        this.addedObjects = null;
        this.removedObjects.clear();
        this.removedObjects = null;
        this.changedObjects.clear();
        this.changedObjects = null;
        this.resourcesToSave.clear();
        this.resourcesToSave = null;
    }

    public boolean add(IResource parent, IResource[] affectedResources) {
        ResourceSet resourceSet = this.executionNavigator.getResourceSet();
        int maxi = affectedResources.length;
        for (int i = 0; i < maxi; ++i) {
            EObject[] eObjects;
            if (affectedResources[i].getType() != 1) {
                this.addedObjects.add(affectedResources[i]);
                continue;
            }
            URI uri = this.getFileURI(affectedResources[i]);
            if (uri == null || (eObjects = EMFUtil.load(null, (IFile)affectedResources[i])).length != 1 || !this.isValid(eObjects[0])) continue;
            Resource resource = eObjects[0].eResource();
            resourceSet.getResources().add((Object)resource);
            this.addedObjects.addAll(resource.getContents());
        }
        return false;
    }

    public boolean remove(IResource parent, IResource[] affectedResources) {
        ResourceSet resourceSet = this.executionNavigator.getResourceSet();
        int maxi = affectedResources.length;
        for (int i = 0; i < maxi; ++i) {
            Resource resource;
            if (affectedResources[i].getType() != 1) {
                this.removedObjects.add(affectedResources[i]);
                continue;
            }
            URI uri = this.getFileURI(affectedResources[i]);
            if (uri == null || (resource = resourceSet.getResource(uri, false)) == null) continue;
            this.removedObjects.addAll(resource.getContents());
            this.resourcesToSave.addAll(Arrays.asList(EMFUtil.remove(resource)));
        }
        return false;
    }

    public boolean replaced(IResource affectedResource) {
        return false;
    }

    public boolean updateProperties(IResource affectedResource) {
        if (affectedResource.getType() == 1) {
            Object[] eObjects = EMFUtil.getEObjects(this.executionNavigator.getResourceSet(), (IFile)affectedResource);
            if (eObjects.length > 0) {
                this.executionNavigator.getTreeViewer().update(eObjects, null);
            }
        } else {
            this.executionNavigator.getTreeViewer().update((Object)affectedResource, null);
        }
        return false;
    }

    public boolean updateChildrenType(IResource affectedResource) {
        return false;
    }

    public boolean updateContent(IResource parent, IResource affectedResource) {
        Resource resource;
        URI uri = this.getFileURI(affectedResource);
        if (uri != null && (resource = this.executionNavigator.getResourceSet().getResource(uri, false)) != null) {
            this.removedObjects.addAll(resource.getContents());
            resource.unload();
            try {
                resource.load(EMFUtil.RESOURCE_OPTIONS);
            }
            catch (IOException e) {
                TestUIPlugin.logError(e);
            }
            this.changedObjects.add(resource);
            this.addedObjects.addAll(resource.getContents());
            if (this.expandedElements == null) {
                this.expandedElements = this.executionNavigator.getTreeViewer().getExpandedElements();
                this.convertEObjectToURI(this.expandedElements);
                this.selectedElements = ((IStructuredSelection)this.executionNavigator.getTreeViewer().getSelection()).toArray();
                this.convertEObjectToURI(this.selectedElements);
            }
        }
        return false;
    }

    public void setActive(boolean enable) {
        this.active = enable;
    }

    public boolean isActive() {
        return this.active;
    }

    protected URI getFileURI(IResource resource) {
        String fileExtension;
        if (resource.getType() == 1 && ("testsuite".equals(fileExtension = resource.getFileExtension()) || "execution".equals(fileExtension))) {
            return URI.createPlatformResourceURI((String)resource.getFullPath().toString());
        }
        return null;
    }

    protected boolean isValid(EObject eObject) {
        return eObject instanceof CMNNamedElement;
    }

    private void convertEObjectToURI(Object[] objects) {
        int maxi = objects.length;
        for (int i = 0; i < maxi; ++i) {
            if (!(objects[i] instanceof EObject)) continue;
            objects[i] = EcoreUtil.getURI((EObject)((EObject)objects[i]));
        }
    }

    private void convertURIToEObject(Object[] objects) {
        int maxi = objects.length;
        for (int i = 0; i < maxi; ++i) {
            if (!(objects[i] instanceof URI)) continue;
            objects[i] = this.executionNavigator.getResourceSet().getEObject((URI)objects[i], false);
        }
    }
}

