/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class AvailableSituationImplTest
extends TestCase {
    private AvailableSituation sit;

    public AvailableSituationImplTest(String string) {
        super(string);
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.sit.toString());
    }

    public void testInterface() {
        this.sit.getAvailabilityDisposition();
        this.sit.getOperationDisposition();
        this.sit.getProcessingDisposition();
        this.sit.getReasoningScope();
        Assert.assertTrue((boolean)(this.sit instanceof SituationType));
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.sit);
    }

    public void testEquals() {
        AvailableSituation availableSituation = (AvailableSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)availableSituation);
        this.sit.setAvailabilityDisposition("a");
        this.sit.setOperationDisposition("z");
        this.sit.setProcessingDisposition("p");
        this.sit.setReasoningScope("r");
        availableSituation = (AvailableSituation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)availableSituation);
        availableSituation.setAvailabilityDisposition("difference");
        Assert.assertFalse((boolean)this.sit.equals(availableSituation));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.sit, "all");
        this.sit.setAvailabilityDisposition("a");
        this.sit.setOperationDisposition("o");
        this.sit.setProcessingDisposition("p");
        this.sit.setReasoningScope("r");
        this.sit.validate();
        this.sit.setAvailabilityDisposition(null);
        Util.assertMissingAttributes(this.sit, "availabilityDisposition");
        this.sit.setAvailabilityDisposition("a");
        this.sit.setOperationDisposition(null);
        this.sit.setProcessingDisposition("p");
        this.sit.setReasoningScope("r");
        Util.assertMissingAttributes(this.sit, "operationDisposition");
        this.sit.setAvailabilityDisposition("a");
        this.sit.setOperationDisposition("o");
        this.sit.setProcessingDisposition(null);
        this.sit.setReasoningScope("r");
        Util.assertMissingAttributes(this.sit, "processingDisposition");
        this.sit.setAvailabilityDisposition("a");
        this.sit.setOperationDisposition("o");
        this.sit.setProcessingDisposition("p");
        this.sit.setReasoningScope(null);
        Util.assertMissingAttributes(this.sit, "reasoningScope");
    }

    public void testValidationInvalidLengths() {
        this.sit.setAvailabilityDisposition(Util.getPaddedString(64));
        this.sit.setOperationDisposition(Util.getPaddedString(64));
        this.sit.setProcessingDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        try {
            this.sit.validate();
        }
        catch (ValidationException validationException) {
            Assert.fail((String)"Strings have correct length");
        }
        this.sit.setAvailabilityDisposition(Util.getPaddedString(65));
        this.sit.setOperationDisposition(Util.getPaddedString(64));
        this.sit.setProcessingDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "setAvailabilityDisposition");
        this.sit.setAvailabilityDisposition(Util.getPaddedString(64));
        this.sit.setOperationDisposition(Util.getPaddedString(65));
        this.sit.setProcessingDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "operationDisposition");
        this.sit.setAvailabilityDisposition(Util.getPaddedString(64));
        this.sit.setOperationDisposition(Util.getPaddedString(64));
        this.sit.setProcessingDisposition(Util.getPaddedString(65));
        this.sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(this.sit, "processingDisposition");
        this.sit.setAvailabilityDisposition(Util.getPaddedString(64));
        this.sit.setOperationDisposition(Util.getPaddedString(64));
        this.sit.setProcessingDisposition(Util.getPaddedString(64));
        this.sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(this.sit, "reasoningScope");
    }

    public void testAdapter() {
        Util.assertAdapterNotification(this.sit);
    }

    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(this.sit);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eventFactory = EventFactory.eINSTANCE;
        this.sit = eventFactory.createAvailableSituation();
    }
}

