/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryObjectFactory;

public class EventFactoryObjectFactoryTest
extends TestCase
implements Serializable {
    public EventFactoryObjectFactoryTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetObjectInstance() throws Exception {
        MockHandler mockHandler = new MockHandler("Example");
        EventFactoryImpl eventFactoryImpl = new EventFactoryImpl();
        eventFactoryImpl.setContentHandler(mockHandler);
        Reference reference = eventFactoryImpl.getReference();
        EventFactoryObjectFactory eventFactoryObjectFactory = new EventFactoryObjectFactory();
        EventFactory eventFactory = (EventFactory)eventFactoryObjectFactory.getObjectInstance((Object)reference, (Name)new CompositeName("AA"), (Context)null, (Hashtable)null);
        Assert.assertNotNull((String)"Returned factory cannot be null", (Object)eventFactory);
        CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent("someExtension");
        commonBaseEvent.complete();
        Assert.assertEquals((String)"Mediation must change extension name", (String)commonBaseEvent.getExtensionName(), (String)"Example");
    }

    public class MockHandler
    implements ContentHandler,
    Serializable {
        private String extensionName;

        public MockHandler(String string) {
            this.extensionName = string;
        }

        public void completeEvent(CommonBaseEvent commonBaseEvent) throws CompletionException {
            commonBaseEvent.setExtensionName(this.extensionName);
        }
    }
}

