/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.w3c.dom.Node;

class StandalonePluginClassDescriptor
implements IHyadesPluginClassDescriptor {
    protected Node element;
    protected String attributeName;

    public StandalonePluginClassDescriptor(Node element, String attributeName) {
        this.element = element;
        this.attributeName = attributeName;
    }

    public Object createInstance() {
        Object ret = null;
        String className = this.getFirstRealChild().getAttributes().getNamedItem(this.attributeName).getNodeValue();
        try {
            Class<?> clazz = Class.forName(className);
            ret = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LoadersUtils.log(e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (InstantiationException e) {
            LoadersUtils.log(e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            LoadersUtils.log(e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return ret;
    }

    private Node getFirstRealChild() {
        Node node;
        for (node = this.element.getFirstChild(); node != null && node.getAttributes() == null; node = node.getNextSibling()) {
        }
        return node;
    }
}

