/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.AnalyzerEnv;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.OrbThreadPool;
import org.eclipse.hyades.collection.threadanalyzer.OverallThreadPool;
import org.eclipse.hyades.collection.threadanalyzer.ServletThreadPool;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TOSInfo;
import org.eclipse.hyades.collection.threadanalyzer.TaGridElement;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpData
implements Externalizable {
    private static int _curVersion = 2;
    private int _version = -1;
    protected int _totThreads = 0;
    protected int _webWaitThreads = 0;
    protected int _orbWaitThreads = 0;
    protected int _workingOrbThreads = 0;
    protected int _workingWebThreads = 0;
    protected int _unknownThreads = 0;
    protected int _analysisType = 3;
    private int _logLevel = 3;
    public boolean _fHtml = false;
    private Hashtable _threads = null;
    private Hashtable _monitors = null;
    public AnalyzerEnv _env = null;
    protected String _inputFilename = null;
    public int _threadsMissingStacks = 0;
    protected ThreadDump _threadDump = null;
    protected String _description = null;
    protected String _displayName = null;
    protected String dumpParserClassName = null;
    protected String _dumpingJvmName = null;
    protected static final String _sTab = "   ";
    protected transient ResourceBundle _tosTrans = null;
    protected static int _majorVersion = 1;
    protected static int _minorVersion = 1;
    protected transient PrintStream _rptOut = System.out;
    public static final int ANALYZE_SERVLET = 1;
    public static final int ANALYZE_EJB = 2;
    public static final int ANALYZE_WAS = 3;
    public static final int ANALYZE_OTHER = 32768;
    public static final int ANALYZE_ALL = -1;
    private static int _curID = 0;
    public transient Hashtable _threadsByTOS = null;
    public transient TOSInfo _tosInfo = null;
    public transient Vector _threadDetailHelpers = null;
    public transient Vector _monitorDetailHelpers = null;
    private transient Vector deadlockResults = null;
    private transient boolean deadlockExists = false;

    public static synchronized int getID() {
        return ++_curID;
    }

    public DumpData() {
        this._version = _curVersion;
        this._threads = new Hashtable();
        this._monitors = new Hashtable();
        this._threadsByTOS = new Hashtable();
        this._env = new AnalyzerEnv();
        this._fHtml = DumpParser.getArg("reportType").equalsIgnoreCase("html");
        this._threadDump = new ThreadDump();
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDumpingJvmName() {
        return this._dumpingJvmName;
    }

    public void setDumpingJvmName(String jvmName) {
        this._dumpingJvmName = jvmName;
    }

    public void addDumpTextLine(String line, int lineNo) {
        this._threadDump.addLine(line, lineNo);
    }

    public Enumeration getDumpTextEnum() {
        return this._threadDump.getEnumerator();
    }

    public String getNextDumpTextLine(Enumeration enumeration) {
        return this._threadDump.getNextLine(enumeration);
    }

    public void setInputFilename(String filename) {
        this._inputFilename = filename;
    }

    public Thd addThd(String name, String threadId, String state, String priority) {
        Thd thd = new Thd(name, threadId, state, priority);
        this._threads.put(threadId, thd);
        this.logDebug("[DumpData] added thread: " + name + " " + threadId);
        return thd;
    }

    public Thd getThd(String thdId) {
        return (Thd)this._threads.get(thdId);
    }

    public int getThreadDumpSize() {
        return this._threadDump.getSize();
    }

    public ServletThreadPool getServletThreadPool() {
        return new ServletThreadPool(this);
    }

    public OrbThreadPool getOrbThreadPool() {
        return new OrbThreadPool(this);
    }

    public OverallThreadPool getOverallThreadPool() {
        return new OverallThreadPool(this);
    }

    public void buildCommonTOSLists() {
        if (this._threadsByTOS == null) {
            this._threadsByTOS = new Hashtable();
        }
        Enumeration enumeration = null;
        boolean count = false;
        enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            String sKey = (String)enumeration.nextElement();
            Thd thd = this.getThd(sKey);
            int ndx = Integer.parseInt(thd.getProperty("SIGNIFICANT_TOS_NDX"));
            String stkKey = null;
            if (ndx >= 0) {
                StkEntry se = thd.getStkEntry(ndx);
                if (se != null) {
                    stkKey = se.getFQName();
                } else {
                    this.logErr("[DumpData] ERROR: stack entry is null");
                }
            } else {
                stkKey = "*** WARNING *** Thread with empty stack";
            }
            Vector<Thd> vec = (Vector<Thd>)this._threadsByTOS.get(stkKey);
            if (thd.getName().indexOf("Signal dispatcher") != -1) continue;
            if (vec != null) {
                vec.add(thd);
                continue;
            }
            vec = new Vector<Thd>();
            vec.add(thd);
            this._threadsByTOS.put(stkKey, vec);
        }
        count = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            String stkKey = (String)enumeration.nextElement();
            Vector vec = (Vector)this._threadsByTOS.get(stkKey);
            Thd tPrev = null;
            Thd tCur = null;
            for (int i = 0; i < vec.size(); ++i) {
                tCur = (Thd)vec.elementAt(i);
                tCur._prevByTOS = tPrev;
                tPrev = tCur;
                if (i + 1 >= vec.size()) continue;
                tCur._nextByTOS = (Thd)vec.elementAt(i + 1);
            }
        }
    }

    public Monitor addMonitor(String name, int mon_type) {
        Monitor mon = null;
        name = name.trim();
        mon = new Monitor(name, mon_type);
        this._monitors.put(name, mon);
        return mon;
    }

    public Enumeration getMonitorEnum() {
        Enumeration enumeration = this._monitors.keys();
        return enumeration;
    }

    public Monitor getNextMonitor(Enumeration enumeration) {
        String key = null;
        Monitor retVal = null;
        if (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            retVal = (Monitor)this._monitors.get(key);
        }
        return retVal;
    }

    public Monitor getMonitorById(int id) {
        Enumeration e = this.getMonitorEnum();
        Monitor m = this.getNextMonitor(e);
        while (m != null && m.getId() != id) {
            m = this.getNextMonitor(e);
        }
        return m;
    }

    public Thd getThreadById(int id) {
        Enumeration e = this.getThreadEnum();
        Thd t = this.getNextThread(e);
        while (t != null && t.getId() != id) {
            t = this.getNextThread(e);
        }
        return t;
    }

    public Enumeration getThreadEnum() {
        Enumeration enumeration = this._threads.keys();
        return enumeration;
    }

    public Thd getNextThread(Enumeration enumeration) {
        String key = null;
        Thd retVal = null;
        if (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            retVal = (Thd)this._threads.get(key);
        }
        return retVal;
    }

    public Monitor getHeapLock() {
        Enumeration enumeration = this.getMonitorEnum();
        Monitor m = this.getNextMonitor(enumeration);
        while (m != null) {
            if (m._name.equals("HEAP_LOCK")) {
                return m;
            }
            m = this.getNextMonitor(enumeration);
        }
        return null;
    }

    public Vector webLockWaiters(Monitor m) {
        this.logDebug("Checking monitor: " + m.getName() + "  contains " + m._waiters.size() + " waiters");
        Vector vRet = null;
        if (m != null) {
            Vector webWaiters = new Vector();
            for (int i = 0; i < m._waiters.size(); ++i) {
                Thd thd = (Thd)m._waiters.elementAt(i);
                if (!thd.isExecutingWebWork()) continue;
                this.logDebug("  thd: " + i + "  is executing web work");
                webWaiters.add(m._waiters.elementAt(i));
            }
            if (webWaiters.size() > 0) {
                vRet = webWaiters;
            }
        }
        return vRet;
    }

    public Vector orbLockWaiters(Monitor m) {
        Vector vRet = null;
        if (m != null) {
            Vector orbWaiters = new Vector();
            for (int i = 0; i < m._waiters.size(); ++i) {
                Thd thd = (Thd)m._waiters.elementAt(i);
                if (!thd.isExecutingRemoteOrbWork()) continue;
                orbWaiters.add(m._waiters.elementAt(i));
            }
            if (orbWaiters.size() > 0) {
                vRet = orbWaiters;
            }
        }
        return vRet;
    }

    public void writeTo(String fileName) throws Exception {
        try {
            FileOutputStream fo = new FileOutputStream(fileName);
            ObjectOutputStream so = new ObjectOutputStream(fo);
            this.writeExternal(so);
            so.flush();
            so.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static DumpData readFrom(String fileName) throws Exception {
        DumpData cnew = new DumpData();
        FileInputStream fi = new FileInputStream(fileName);
        ObjectInputStream si = new ObjectInputStream(fi);
        cnew.readExternal(si);
        si.close();
        return cnew;
    }

    public void fixupIdRefs() {
        Enumeration enumeration = this.getThreadEnum();
        Thd thd = this.getNextThread(enumeration);
        while (thd != null) {
            Monitor m;
            int monID = thd.getWaitMonitorId();
            if (monID > 0 && (m = this.getMonitorById(monID)) != null) {
                thd.setWaitMonitor(m);
            }
            thd = this.getNextThread(enumeration);
        }
        enumeration = this.getMonitorEnum();
        Monitor m = this.getNextMonitor(enumeration);
        while (m != null) {
            m.fixupWaiters(this);
            m = this.getNextMonitor(enumeration);
        }
    }

    public void initAnalysis() {
        Method helper;
        int i;
        Object[] params;
        this.setAnalysisType();
        this._tosTrans = null;
        try {
            this._tosTrans = ResourceBundle.getBundle("ta_tos_trans");
        }
        catch (Exception e) {
            Locale l = Locale.getDefault();
        }
        this.loadExternalEvaluators(DumpParser.getArg("detailXML"));
        Enumeration enumeration = null;
        String key = null;
        this.calcMissingThreadStacks();
        enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            Thd thd = (Thd)this._threads.get(key);
            params = new Object[]{this._env, thd};
            this.logDebug(thd.getName() + " has a stack size of: " + thd.getStkSize() + ". Threads missing stacks is now: " + this._threadsMissingStacks);
            for (i = 0; i < this._threadDetailHelpers.size(); ++i) {
                helper = (Method)this._threadDetailHelpers.elementAt(i);
                try {
                    helper.invoke(null, params);
                    continue;
                }
                catch (Exception e) {
                    this.logErr("Exception while executing thread detail helper '" + helper.getName() + "'");
                    e.printStackTrace();
                }
            }
        }
        enumeration = this._monitors.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            Monitor m = (Monitor)this._monitors.get(key);
            params = new Object[]{this._env, m};
            for (i = 0; i < this._monitorDetailHelpers.size(); ++i) {
                helper = (Method)this._monitorDetailHelpers.elementAt(i);
                try {
                    helper.invoke(null, params);
                    continue;
                }
                catch (Exception e) {
                    this.logErr("Exception while executing monitor detail helper '" + helper.getName() + "'");
                }
            }
        }
        Vector<String> keys = new Vector<String>();
        enumeration = this._monitors.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            keys.add(key);
        }
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            key = (String)keys.elementAt(i2);
            Monitor m = (Monitor)this._monitors.get(key);
            String coalesce = m.getProperty("COALESCE");
            if (coalesce == null || !coalesce.equals("true")) continue;
            this._monitors.remove(m.getName());
            String newName = null;
            int idx = m.getName().indexOf(64);
            newName = idx > -1 ? m.getName().substring(0, idx) : m.getName();
            Monitor cm = (Monitor)this._monitors.get(newName);
            if (cm != null) {
                cm._waiters.addAll(m._waiters);
                continue;
            }
            m._name = newName;
            this._monitors.put(newName, m);
        }
        this.logDebug("DumpData.print - building common TOS lists");
        this.buildCommonTOSLists();
        this._tosInfo = new TOSInfo(this._threadsByTOS);
        this.logDebug("DumpData.print - determining thread breakdown");
        this._totThreads = 0;
        this._unknownThreads = 0;
        this._webWaitThreads = 0;
        this._orbWaitThreads = 0;
        this._workingWebThreads = 0;
        this._workingOrbThreads = 0;
        enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            ++this._totThreads;
            key = (String)enumeration.nextElement();
            Thd thd = (Thd)this._threads.get(key);
            if (thd.waitingForWebWork()) {
                ++this._webWaitThreads;
            }
            if (thd.waitingForOrbWork()) {
                ++this._orbWaitThreads;
            }
            if (thd.isExecutingWebWork()) {
                ++this._workingWebThreads;
            }
            if (!thd.isExecutingRemoteOrbWork()) continue;
            ++this._workingOrbThreads;
        }
        this._unknownThreads = this._totThreads - (this._webWaitThreads + this._orbWaitThreads + this._workingWebThreads + this._workingOrbThreads);
    }

    public void outputVector(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            this.rptOut2((String)v.elementAt(i));
        }
    }

    public void warnMissingStacks(OutputStream o) {
        PrintStream ps = new PrintStream(o);
        String warnMsg = this.missingStacksMsg();
        if (warnMsg != null && warnMsg.length() > 0) {
            ps.println("WARNING: " + warnMsg);
        }
    }

    protected void calcMissingThreadStacks() {
        this._threadsMissingStacks = 0;
        Enumeration enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Thd thd = (Thd)this._threads.get(key);
            if (thd.getStkSize() > 0 || thd.getName().equalsIgnoreCase("signal dispatcher")) continue;
            ++this._threadsMissingStacks;
        }
    }

    protected Vector warnMissingStacks() {
        Vector<String> v = new Vector<String>();
        String warnMsg = this.missingStacksMsg();
        if (warnMsg != null && warnMsg.length() > 0) {
            this.logWarning(warnMsg);
            v.add("WARNING: " + warnMsg);
        }
        return v;
    }

    protected String missingStacksMsg() {
        this.calcMissingThreadStacks();
        String warnMsg = "";
        if (this._threadsMissingStacks > 0) {
            warnMsg = "" + this._threadsMissingStacks + " threads have no stack information.";
        }
        return warnMsg;
    }

    public void print(String rptName) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(new FileOutputStream(rptName));
        }
        catch (FileNotFoundException fnfe) {
            this.logErr("Cannot create output file " + rptName);
            System.exit(-1);
        }
        this.print(ps);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream ps) {
        this.setPrintStream(ps);
        this.logDebug("DumpData.print( ) begins...");
        this.initAnalysis();
        this.logDebug("DumpData.print - beginning of report");
        if (this._fHtml) {
            this.rptOut("<html>");
            this.rptOut2("<title>Thread dump analysis ");
            if (this._inputFilename != null) {
                this.rptOut2("for " + this._inputFilename);
            }
            this.rptOut2("</title>");
            this.rptOut2("<h2>Thread dump analysis ");
            if (this._inputFilename != null) {
                this.rptOut2("for " + this._inputFilename);
            }
            this.rptOut2("</h2>");
            this.printHeading();
            if (this._analysisType != 3) {
                this.rptOut2("Analysis type:" + DumpParser.getArg("analyze"));
            }
            this.rptOut("<a name=top></a><h2>Contents</h2>");
            this.rptOut2("<ul>");
            this.rptOut2("<li><a href=#disclaimer>Disclaimer</a></li>");
            this.rptOut2("<li><a href=#notice>Notice</a></li>");
            this.rptOut2("<li><a href=#summary>Summary</a></li>");
            this.rptOut2("<li><a href=#observations>Observations</a>");
            this.rptOut2("   <ul>");
            if ((this._analysisType & 1) == 1) {
                this.rptOut2("      <li><a href=#spa>Servlet thread pool analysis</a></li>");
                this.rptOut2("      <li><a href=#sta>Servlet engine thread analysis</a></li>");
                this.rptOut2("      <li><a href=#sma>Servlet engine monitor analysis</a></li>");
            }
            if ((this._analysisType & 2) == 2) {
                this.rptOut2("      <li><a href=#opa>ORB thread pool analysis</a></li>");
                this.rptOut2("      <li><a href=#ota>ORB thread analysis</a></li>");
                this.rptOut2("      <li><a href=#oma>ORB monitor analysis</a></li>");
            }
            if ((this._analysisType & 0x8000) == 32768) {
                this.rptOut2("      <li><a href=#ta>Overall thread analysis</a></li>");
                this.rptOut2("      <li><a href=#ma>Overall monitor analysis</a></li>");
            }
            this.rptOut2("   </ul>");
            this.rptOut2("</li>");
            if (this._logLevel >= 3) {
                this.rptOut2("<a href=#dtd><li>Thread details</li></a>");
                this.rptOut2("<a href=#dmd><li>Monitor details</li></a>");
            }
            this.rptOut2("</ul>");
        }
        Enumeration enumeration = null;
        String key = null;
        this.outputVector(this.disclaimer());
        this.outputVector(this.notice());
        if (this._inputFilename != null) {
            this.rptOut("Input file: " + this._inputFilename);
        }
        this.logDebug("DumpData.print - doing summary section");
        this.outputVector(this.summary());
        this.rptOut();
        this.rptOut();
        this.rptOut();
        this.rptOut(this.html("<a name=observations></a><h1>") + "Observations..." + this.html("</h1>"));
        if ((this._analysisType & 1) == 1) {
            this.logDebug("DumpData.print - doing servlet pool analysis");
            this.outputVector(this.servletPoolAnalysis());
            this.servletThreadPool();
            this.outputVector(this.servletThreadAnalysis());
            this.outputVector(this.servletMonitorAnalysis());
        }
        if ((this._analysisType & 2) == 2) {
            this.logDebug("DumpData.print - doing orb pool analysis");
            this.outputVector(this.orbPoolAnalysis());
            this.orbThreadPool();
            this.outputVector(this.orbThreadAnalysis());
            this.outputVector(this.orbMonitorAnalysis());
        }
        if ((this._analysisType & 0x8000) == 32768) {
            this.logDebug("DumpData.print - doing overall thread analysis");
            this.outputVector(this.overallThreadAnalysis());
            this.overallThreadPool();
            this.outputVector(this.overallMonitorAnalysis());
        }
        this.rptOut(this.html("<h3>") + "End of analysis section" + this.html("</h3>"));
        this.rptOut(" ");
        if (this._logLevel >= 3) {
            this.logDebug("DumpData.print - writing thread details");
            this.rptOut(this.html("<a name=dtd></a><h1>") + "Detailed thread dump" + this.html("</h1>"));
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            enumeration = this._threads.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                Thd thd = (Thd)this._threads.get(key);
                int indent = 0;
                this.rptOut2(this.html("<pre>"));
                this.outputVector(thd.format(indent, this._fHtml));
                this.rptOut2(this.html("<br><a href=#top>[top]</a>"));
                this.rptOut2(this.html("</pre>"));
            }
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            this.rptOut(" ");
            this.logDebug("DumpData.print - writing monitor details");
            enumeration = this.getMonitorEnum();
            Monitor m = this.getNextMonitor(enumeration);
            this.rptOut2(this.html("<a name=dmd></a><h3>") + "Detailed monitor dump" + this.html("</h3>"));
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            while (m != null) {
                this.rptOut2(this.html("<pre>"));
                this.outputVector(m.format(1, this._fHtml));
                this.rptOut2(this.html("<br><a href=#top>[top]</a>"));
                this.rptOut2(this.html("</pre>"));
                m = this.getNextMonitor(enumeration);
            }
            this.rptOut("** END Detailed monitor dump **");
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            this.rptOut(" ");
        }
        this.rptOut("** END OF REPORT **");
        this.rptOut(this.html("</html>"));
        this.logDebug("DumpData.print( ) end.");
        ps.flush();
        ps.close();
    }

    protected void setPrintStream(PrintStream ps) {
        this._rptOut = ps;
    }

    protected void printHeading() {
        this.rptOut("Thread analyzer version: " + DumpData.formattedVersion());
    }

    public Vector summary() {
        Vector<String> v = new Vector<String>();
        v.add("");
        v.add("");
        v.add(this.html("<a name=summary><h1>") + "Summary" + this.html("</h1></a>&nbsp;&nbsp;<a href=#top>[top]</a>"));
        v.add(this.html("<pre>"));
        v.add("Thread utilization summary: ");
        v.add("  Total threads................................................... " + this._totThreads);
        v.add("     threads waiting for web work................................. " + this._webWaitThreads);
        v.add("     threads waiting for remote orb work.......................... " + this._orbWaitThreads);
        v.add("     threads doing web or local orb work.......................... " + this._workingWebThreads);
        v.add("     threads doing remote orb work................................ " + this._workingOrbThreads);
        v.add("     threads doing other (non web or remote orb workload) tasks... " + this._unknownThreads);
        if (this.deadlockExists) {
            v.add("\nDeadlock(s) found.  See Overall Monitor Analysis for details.");
        } else {
            v.add("\nNo deadlock(s) found.");
        }
        v.add(this.html("<a href=#top>[top]</a>"));
        v.add(this.html("</pre>"));
        return v;
    }

    public Vector disclaimer() {
        Vector<String> v = new Vector<String>();
        v.add(this.html("<a name=disclaimer></a><h3>") + "Disclaimer" + this.html("</h3>"));
        v.add(this.html("<pre>"));
        v.add("      IBM has made every effort to ensure information and");
        v.add("      recommendations to be  correct.  However, results are not");
        v.add("      guaranteed.  System changes should not be made based");
        v.add("      on information obtained using this or any other tool");
        v.add("      without full consideration of the possible ramifications");
        v.add("      of such changes.");
        v.add(this.html("</pre>"));
        v.add(this.html("<a href=#top>[top]</a>"));
        return v;
    }

    public Vector notice() {
        Vector<String> v = new Vector<String>();
        v.add(this.html("<a name=notice></a><h3>") + "Notice" + this.html("</h3>"));
        v.add(this.html("<pre>"));
        v.add("      This tool primarily focuses on threads created by the IBM WebSphere server runtime.");
        v.add("      Also, the tool assumes that a representative workload is being driven through");
        v.add("      the system for analysis.");
        v.add(this.html("</pre>"));
        v.add(this.html("<a href=#top>[top]</a>"));
        return v;
    }

    public void servletThreadPool() {
        ServletThreadPool stp = this.getServletThreadPool();
        TaGridElement[][] gea = stp.getTosGrid();
        Object[] headers = stp.getTosGridHeaders();
        this.rptOut2(this.html("<b>") + "Top of stack information. " + this.html("</b>"));
        this.rptOut2("Highest weight items *may* indicate the need for more analysis.");
        this.rptOut2("Items with a weight of 0 are shown for completeness, but represent");
        this.rptOut2("   non-applicable system functions.");
        if (gea != null) {
            int r;
            this.rptOut2(this.html("<table border=1 ><tr>"));
            int rows = gea.length;
            int cols = gea[0].length;
            String heading = "";
            for (r = 0; r < headers.length; ++r) {
                heading = heading + this.html("<th>") + headers[r].toString() + "\t\t" + this.html("</th>");
            }
            this.rptOut2(heading);
            this.rptOut2(this.html("</tr>"));
            for (r = 0; r < rows; ++r) {
                this.rptOut2(this.html("<tr>"));
                String line = "";
                for (int c = 0; c < cols; ++c) {
                    line = line + this.html("<td>") + gea[r][c].toString() + "\t\t" + this.html("</td>");
                }
                this.rptOut2(line);
                this.rptOut2(this.html("</tr>"));
            }
            this.rptOut2(this.html("</table><br><br>"));
        }
    }

    public void orbThreadPool() {
        OrbThreadPool otp = this.getOrbThreadPool();
        TaGridElement[][] gea = otp.getTosGrid();
        Object[] headers = otp.getTosGridHeaders();
        this.rptOut2(this.html("<br><b>") + "Top of stack information. " + this.html("</b><br>"));
        this.rptOut2("Highest weight items *may* indicate the need for more analysis.");
        this.rptOut2("Items with a weight of 0 are shown for completeness, but represent");
        this.rptOut2("   non-applicable system functions.");
        if (gea != null) {
            int r;
            this.rptOut2(this.html("<table border=1 ><tr>"));
            int rows = gea.length;
            int cols = gea[0].length;
            String heading = "";
            for (r = 0; r < headers.length; ++r) {
                heading = heading + this.html("<th>") + headers[r].toString() + "\t\t" + this.html("</th>");
            }
            this.rptOut2(heading);
            this.rptOut2(this.html("</tr>"));
            for (r = 0; r < rows; ++r) {
                this.rptOut2(this.html("<tr>"));
                String line = "";
                for (int c = 0; c < cols; ++c) {
                    line = line + this.html("<td>") + gea[r][c].toString() + "\t\t" + this.html("</td>");
                }
                this.rptOut2(line);
                this.rptOut2(this.html("</tr>"));
            }
            this.rptOut2(this.html("</table><br><br>"));
        }
    }

    public void overallThreadPool() {
        OverallThreadPool otp = this.getOverallThreadPool();
        TaGridElement[][] gea = otp.getTosGrid();
        Object[] headers = otp.getTosGridHeaders();
        this.rptOut2(this.html("<b>") + "Top of stack information. " + this.html("</b>"));
        this.rptOut2("Overall thread analysis should be interpreted carefully.");
        this.rptOut2("Items with a high number of associated threads *may not*");
        this.rptOut2("   be items of concern since threads waiting for work");
        this.rptOut2("   will show up with large numbers of associated threads.");
        if (gea != null) {
            int r;
            this.rptOut2(this.html("<table border=1 ><tr>"));
            int rows = gea.length;
            int cols = gea[0].length;
            String heading = "";
            for (r = 0; r < headers.length; ++r) {
                heading = heading + this.html("<th>") + headers[r].toString() + "\t\t" + this.html("</th>");
            }
            this.rptOut2(heading);
            this.rptOut2(this.html("</tr>"));
            for (r = 0; r < rows; ++r) {
                this.rptOut2(this.html("<tr>"));
                String line = "";
                for (int c = 0; c < cols; ++c) {
                    line = line + this.html("<td>") + gea[r][c].toString() + "\t\t" + this.html("</td>");
                }
                this.rptOut2(line);
                this.rptOut2(this.html("</tr>"));
            }
            this.rptOut2(this.html("</table><br><br>"));
        }
    }

    public Vector orbPoolAnalysis() {
        return this.orbPoolAnalysis(this._tosTrans, this._orbWaitThreads, this._workingOrbThreads);
    }

    protected Vector orbPoolAnalysis(ResourceBundle tosTrans, int waitingThreads, int workingThreads) {
        Vector<String> v = new Vector<String>();
        Object enum_ = null;
        Object key = null;
        int apparentPoolSize = waitingThreads + workingThreads;
        double fractionOfPoolWorking = (double)workingThreads / (double)apparentPoolSize;
        double pctPoolWorking = fractionOfPoolWorking * 100.0;
        v.add(this.html("<pre>"));
        v.add(this.html("<a name=opa></a><h3>") + "ORB thread pool analysis" + this.html("</h3>"));
        if (workingThreads > 0) {
            if (fractionOfPoolWorking < 0.8) {
                v.add("      The ORB remote call handler thread pool does not seem to be driven to full capacity.");
                v.add("      It's possible that there's a network bandwidth or workload generator constraint.");
                v.add("");
                if (apparentPoolSize > 5) {
                    v.add("      It appears that the workload in this pool may be bursty.");
                    v.add("         Since the ORB remote call handler pool size is dynamic,");
                    v.add("         it's possible that some other resource may be fully consumed");
                    v.add("         causing ORB requests to not be handled effectively.");
                }
            } else if (fractionOfPoolWorking > 0.98) {
                if (apparentPoolSize <= 5) {
                    v.add("      The pool should expand itself.");
                } else {
                    v.add("       The pool has apparently expanded from the default of 5 to " + apparentPoolSize);
                }
            } else {
                v.add("      The pool seems to be adequately utilized assuming relatively");
                v.add("         full resource utilization across the system");
            }
        } else {
            v.add("   No ORB remote call handler workload appears to be active");
        }
        v.add(this.html("<a href=#top>[top]</a>"));
        v.add(this.html("</pre>"));
        v.add("");
        v.add("");
        return v;
    }

    public Vector orbThreadAnalysis() {
        Vector<String> v = new Vector<String>();
        Enumeration enumeration = null;
        String key = null;
        v.add(this.html("<a name=ota></a><h3>") + "ORB thread analysis" + this.html("</h3>"));
        boolean fReportedProblems = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            Enumeration ejbNames;
            double dFractOfWorking;
            key = (String)enumeration.nextElement();
            Vector vec = (Vector)this._threadsByTOS.get(key);
            int orbThreads = 0;
            int nonOrbThreads = 0;
            Vector callers = new Vector();
            Thd thdPrior = null;
            Hashtable<String, Integer> ejbs = new Hashtable<String, Integer>();
            int qualCount = 0;
            for (int i = 0; i < vec.size(); ++i) {
                Thd thd = (Thd)vec.elementAt(i);
                if (thd.isExecutingRemoteOrbWork()) {
                    ++qualCount;
                    if (thdPrior != null) {
                        thd.firstStackDifference(callers, thdPrior);
                    }
                    if (qualCount == 2) {
                        thdPrior.firstStackDifference(callers, thd);
                    }
                    thdPrior = thd;
                    ++orbThreads;
                    String[] ejbNames2 = thd.getEjbNames();
                    if (ejbNames2.length == 0) continue;
                    for (int j = 0; j < ejbNames2.length; ++j) {
                        Integer count = (Integer)ejbs.get(ejbNames2[j]);
                        count = count == null ? new Integer(1) : new Integer(count + 1);
                        ejbs.put(ejbNames2[j], count);
                    }
                    continue;
                }
                ++nonOrbThreads;
            }
            if (orbThreads <= true) continue;
            v.add(this.html("<pre>"));
            fReportedProblems = true;
            v.add("      " + key + " seems to be a ");
            String sNonOrb = ".";
            if (nonOrbThreads > 0) {
                sNonOrb = " and " + nonOrbThreads + " non-ORB remote call handler threads.";
            }
            v.add("            concurrently executed by " + orbThreads + " ORB remote call handler threads" + sNonOrb);
            String tosText = null;
            try {
                tosText = this._tosTrans.getString(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tosText != null) {
                v.add("         SPECIFICS about " + key);
                v.add(this.format(18, 80, "This method " + tosText));
            }
            if ((dFractOfWorking = (double)orbThreads / (double)this._workingOrbThreads) > 0.25) {
                int pctWorking = (int)(dFractOfWorking * 100.0);
                v.add("         Since " + pctWorking + "% (" + orbThreads + " out of " + this._workingOrbThreads + ") of the threads doing ORB remote call handler work seem to be");
                v.add("             executing this method, it would seem that there ");
                v.add("             is some possibility that this method and its call path");
                v.add("             may warrant investigation.");
            }
            if ((ejbNames = ejbs.keys()).hasMoreElements()) {
                v.add("         EJBs affected: ");
            }
            while (ejbNames.hasMoreElements()) {
                String sKey = (String)ejbNames.nextElement();
                v.add("            " + sKey + " [" + (Integer)ejbs.get(sKey) + " occurrances]");
            }
            v.add("         callers (ORB RCH threads only): ");
            if (callers.size() <= 0) {
                v.add("            The method seems to be called by EJBs from one code path.");
            }
            for (int i = 0; i < callers.size(); ++i) {
                v.add("            " + Thd.getCallerName(callers.elementAt(i)) + " [" + Thd.getCallerCount(callers.elementAt(i)) + "]");
            }
            v.add(" ");
            v.add(this.html("</pre>"));
        }
        if (!fReportedProblems) {
            v.add("         no observations to report.");
        }
        v.add(this.html("<a href=#top>[top]</a>"));
        v.add("");
        v.add("");
        return v;
    }

    public Vector orbMonitorAnalysis() {
        return this.orbMonitorAnalysis(this._workingOrbThreads);
    }

    protected Vector orbMonitorAnalysis(int workingRmtOrbThreads) {
        Vector<String> v = new Vector<String>();
        v.add(this.html("<a name=oma></a><h3>") + "ORB monitor analysis" + this.html("</h1>"));
        Enumeration lockEnum = this.getMonitorEnum();
        Monitor m = null;
        int blockedCount = 0;
        Vector callers = new Vector();
        v.add(this.html("<pre>"));
        while ((m = this.getNextMonitor(lockEnum)) != null) {
            Vector orbWaiters = this.orbLockWaiters(m);
            int waiters = 0;
            if (orbWaiters != null) {
                waiters = orbWaiters.size();
            }
            if (waiters <= 0) continue;
            ++blockedCount;
            v.add("      Lock name: " + m.getName());
            if (m.getName().equals("com.ibm.ejs.cm.pool.Waiter")) {
                v.add("         NOTE: " + m.getName() + " is the monitor used to mutex datasource");
                v.add("               connection pools within WebSphere. It's very possible that");
                v.add("               SLIGHTLY increasing the connection pool size for the affected datasource.");
                v.add("               may relieve the constraint.");
            }
            v.add("         There is/are " + waiters + " ORB remote call handler thread(s) waiting on the lock.");
            this.logDebug("Threre are " + workingRmtOrbThreads + " working remote threads.");
            double fractionWaiting = (double)waiters / (double)workingRmtOrbThreads;
            if (fractionWaiting > 0.25) {
                v.add("         It seems that a significant number of ORB remote call handler threads doing work");
                v.add("            are blocked on this lock.");
                v.add("         Understanding the usage of this lock");
                v.add("            may be important.");
            }
            v.add("");
            Thd thdPrior = null;
            for (int i = 0; i < waiters; ++i) {
                Thd thd = (Thd)orbWaiters.elementAt(i);
                if (thdPrior != null) {
                    thd.firstStackDifference(callers, thdPrior);
                }
                if (i == 1) {
                    thdPrior.firstStackDifference(callers, thd);
                }
                thdPrior = thd;
            }
        }
        if (blockedCount == 0) {
            v.add("      No 'running' ORB remote call handler threads seem to be blocked by java monitors.");
            v.add("         NOTE: running means threads not waiting for work.");
            v.add("                 since threads waiting for work always appear blocked.");
        } else {
            v.add("      Blocked callers: ");
            if (callers.size() <= 0) {
                v.add("         The blockage seems to be entered from one code path.");
            }
            for (int i = 0; i < callers.size(); ++i) {
                v.add("         " + Thd.getCallerName(callers.elementAt(i)) + " [" + Thd.getCallerCount(callers.elementAt(i)) + "]");
            }
        }
        v.add(this.html("<a href=#top>[top]</a>"));
        v.add("");
        v.add("");
        v.add(this.html("</pre>"));
        return v;
    }

    public Vector overallThreadAnalysis() {
        return this.overallThreadAnalysis(this._tosTrans);
    }

    protected Vector overallThreadAnalysis(ResourceBundle tosTrans) {
        Vector<String> v = new Vector<String>();
        v.add(this.html("<a name=ta></a><h3>") + "Overall thread analysis" + this.html("</h3>"));
        v.add(this.html("<pre>"));
        Enumeration enumeration = null;
        String key = null;
        boolean fReportedProblems = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            Vector vec = (Vector)this._threadsByTOS.get(key);
            int threads = 0;
            Vector callers = new Vector();
            Thd thdPrior = null;
            for (int i = 0; i < vec.size(); ++i) {
                Thd thd = (Thd)vec.elementAt(i);
                if (thdPrior != null) {
                    thd.firstStackDifference(callers, thdPrior);
                }
                if (i == vec.size() - 1 && vec.size() > 1) {
                    thdPrior.firstStackDifference(callers, thd);
                }
                thdPrior = thd;
                ++threads;
            }
            if (threads <= true) continue;
            fReportedProblems = true;
            v.add("      " + key + " is being executed by ");
            v.add("            " + threads + " threads.");
            String tosText = null;
            try {
                tosText = tosTrans.getString(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tosText != null) {
                v.add("         SPECIFICS about " + key);
                v.add(this.format(18, 80, "This method " + tosText));
            }
            v.add("         callers: ");
            if (callers.size() <= 0) {
                v.add("            The method seems to be called from one code path.");
            }
            for (int i = 0; i < callers.size(); ++i) {
                v.add("            " + Thd.getCallerName(callers.elementAt(i)) + " [" + Thd.getCallerCount(callers.elementAt(i)) + "]");
            }
            v.add(" ");
        }
        if (!fReportedProblems) {
            v.add("         no observations to report.");
        }
        v.add(this.html("<a href=#top>[top]</a>"));
        v.add("");
        v.add("");
        v.add(this.html("</pre>"));
        return v;
    }

    public Vector overallMonitorAnalysis() {
        Vector<String> v = new Vector<String>();
        if (this._monitors.size() > 0) {
            v.add(this.html("<a name=ma></a><h3>") + "Overall monitor analysis" + this.html("</h1>"));
        } else if (this.deadlockResults == null) {
            v.add(this.html("<a name=ma></a><h3>") + "No monitor information in thread dump provided by JDK" + this.html("</h1>"));
        }
        if (this.deadlockResults != null) {
            v.addAll(this.deadlockResults);
        }
        return v;
    }

    public Vector servletMonitorAnalysis() {
        return this.servletMonitorAnalysis(this._workingWebThreads);
    }

    protected Vector servletMonitorAnalysis(int workingWebThreads) {
        Vector<String> v = new Vector<String>();
        v.add(this.html("<a name=sma></a><h3>") + "Servlet engine monitor analysis" + this.html("</h1>"));
        v.add(this.html("<pre>"));
        Enumeration lockEnum = this.getMonitorEnum();
        Monitor m = null;
        int blockedCount = 0;
        Vector callers = new Vector();
        while ((m = this.getNextMonitor(lockEnum)) != null) {
            Vector webWaiters = this.webLockWaiters(m);
            int waiters = 0;
            if (webWaiters != null) {
                waiters = webWaiters.size();
            }
            this.logDebug(waiters + " waiters and " + workingWebThreads + " workingWebThreads");
            if (waiters <= 0) continue;
            ++blockedCount;
            v.add("      Lock name: " + m.getName());
            if (m.getName().equals("com.ibm.ejs.cm.pool.Waiter")) {
                v.add("         NOTE: " + m.getName() + " is the monitor used to mutex datasource");
                v.add("               connection pools within WebSphere. It's very possible that");
                v.add("               SLIGHTLY increasing the connection pool size for the affected datasource.");
                v.add("               may relieve the constraint.");
            }
            v.add("         There is/are " + waiters + " servlet engine thread(s) waiting on the lock.");
            double fractionWaiting = (double)waiters / (double)workingWebThreads;
            if (fractionWaiting > 0.25) {
                v.add("         It seems that a significant number of servlet threads doing work");
                v.add("            (" + waiters + " out of " + workingWebThreads + ") are waiting on this lock.");
                v.add("         Understanding the reason behind this wait ");
                v.add("            could lead to a way to improve performance for the servlets involved.");
            }
            v.add("");
            Thd thdPrior = null;
            for (int i = 0; i < waiters; ++i) {
                Thd thd = (Thd)webWaiters.elementAt(i);
                if (thdPrior != null) {
                    thd.firstStackDifference(callers, thdPrior);
                }
                if (i == 1) {
                    thdPrior.firstStackDifference(callers, thd);
                }
                thdPrior = thd;
            }
        }
        if (blockedCount == 0) {
            v.add("      No 'running' servlet threads seem to be blocked by java monitors.");
            v.add("         NOTE: running means servlet threads not waiting for work.");
            v.add("                 since servlet threads waiting for work always appear blocked.");
        } else {
            v.add("      Blocked callers: ");
            if (callers.size() <= 0) {
                v.add("         The blockage seems to be entered from one code path.");
            }
            for (int i = 0; i < callers.size(); ++i) {
                v.add("         " + Thd.getCallerName(callers.elementAt(i)) + " [" + Thd.getCallerCount(callers.elementAt(i)) + "]");
            }
        }
        v.add(this.html("<a href=#top>[top]</a>"));
        v.add("");
        v.add("");
        v.add(this.html("</pre>"));
        return v;
    }

    public Vector servletPoolAnalysis() {
        return this.servletPoolAnalysis(this._tosTrans, this._webWaitThreads, this._workingWebThreads);
    }

    protected Vector servletPoolAnalysis(ResourceBundle tosTrans, int webWaitThreads, int workingWebThreads) {
        Vector<String> v = new Vector<String>();
        String sTab = _sTab;
        Object enum_ = null;
        Object key = null;
        int apparentWebPoolSize = webWaitThreads + workingWebThreads;
        double fractionOfWebPoolWorking = (double)workingWebThreads / (double)apparentWebPoolSize;
        double pctWebPoolWorking = fractionOfWebPoolWorking * 100.0;
        v.add(this.html("<a name=spa></a><h3>") + "Servlet engine thread pool analysis (MAX CONNECTIONS)" + this.html("</h3>"));
        v.add(this.html("<pre>"));
        if (workingWebThreads > 0) {
            if (fractionOfWebPoolWorking < 0.8) {
                v.add(sTab + "   The servlet thread pool does not seem to be driven to full capacity.");
                v.add(sTab + "   It's possible that there's a network bandwidth or workload generator constraint.");
                v.add("");
                v.add("");
                v.add(sTab + "   It's also possible that the system under test is saturated.");
                v.add(sTab + "      In this case, it's possible that the servlet thread pool may be over allocated.");
                v.add(sTab + "      Check the thread pool size (MAX CONNECTIONS) in the servlet engine configuration.");
                v.add(sTab + "      Currently, it's adequate to allocate no more than 5 or 6 threads per processor");
                v.add(sTab + "         unless the workload tends to wait on external resources, locks or java monitors.");
                v.add(sTab + "         If threads tend to wait, then experimentation may be required to find the \"sweet spot\".");
            } else if (fractionOfWebPoolWorking > 0.98) {
                v.add(sTab + "   If the WebSphere system under test has extra capacity, performance may be enhanced by increasing MAX CONNECTIONS for the servlet engine.");
            } else {
                v.add(sTab + "   Assuming the system under test is near capacity with respect to resources, it would seem that the servlet engine is adequately busy.");
                v.add(sTab + "      more analysis will follow.");
            }
        } else {
            v.add(sTab + "No servlet workload appears to be active");
        }
        v.add(this.html("<a href=#top>[top]</a>"));
        v.add("");
        v.add("");
        return v;
    }

    public Vector servletThreadAnalysis() {
        Vector<String> v = new Vector<String>();
        Enumeration enumeration = null;
        String key = null;
        String sTab = _sTab;
        v.add(this.html("<a name=sta></a><h3>") + "Servlet engine thread analysis" + this.html("</h3>"));
        boolean fReportedProblems = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            Enumeration servletNames;
            double dFractOfWorking;
            key = (String)enumeration.nextElement();
            Vector vec = (Vector)this._threadsByTOS.get(key);
            int servletThreads = 0;
            int nonServletThreads = 0;
            Vector callers = new Vector();
            Thd thdPrior = null;
            Hashtable<String, Integer> servlets = new Hashtable<String, Integer>();
            int qualCount = 0;
            for (int i = 0; i < vec.size(); ++i) {
                Thd thd = (Thd)vec.elementAt(i);
                if (thd.isExecutingWebWork()) {
                    ++qualCount;
                    if (thdPrior != null) {
                        thd.firstStackDifference(callers, thdPrior);
                    }
                    if (qualCount == 2) {
                        thdPrior.firstStackDifference(callers, thd);
                    }
                    thdPrior = thd;
                    ++servletThreads;
                    String servletName = thd.getServletName();
                    if (servletName == null) continue;
                    Integer count = (Integer)servlets.get(servletName);
                    count = count == null ? new Integer(1) : new Integer(count + 1);
                    servlets.put(servletName, count);
                    continue;
                }
                ++nonServletThreads;
            }
            if (servletThreads <= true) continue;
            fReportedProblems = true;
            v.add(sTab + _sTab + key + " seems to be currently executing on ");
            String sNonServlet = ".";
            if (nonServletThreads > 0) {
                sNonServlet = " and " + nonServletThreads + " non-servlet threads.";
            }
            v.add(sTab + "          " + servletThreads + " servlet threads" + sNonServlet);
            String tosText = null;
            try {
                tosText = this._tosTrans.getString(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tosText != null) {
                v.add(sTab + "      SPECIFICS about " + key);
                v.add(this.format(18, 80, "This method " + tosText));
            }
            if ((dFractOfWorking = (double)servletThreads / (double)this._workingWebThreads) > 0.25) {
                int pctWorking = (int)(dFractOfWorking * 100.0);
                v.add(sTab + "      Since " + pctWorking + "% (" + servletThreads + " out of " + this._workingWebThreads + ") of the threads doing servlet work seem to be");
                v.add("             executing this method, it would seem that there ");
                v.add("             is some possibility that this method and its call path");
                v.add("             may warrant investigation.");
            }
            if ((servletNames = servlets.keys()).hasMoreElements()) {
                v.add(sTab + "      Servlets affected: ");
            }
            while (servletNames.hasMoreElements()) {
                String sKey = (String)servletNames.nextElement();
                v.add(sTab + "         " + sKey + " [" + (Integer)servlets.get(sKey) + " occurrances]");
            }
            v.add(sTab + "      Callers (servlet threads only): ");
            if (callers.size() <= 0) {
                v.add(sTab + "         The method seems to be called by servlets from one code path.");
            }
            for (int i = 0; i < callers.size(); ++i) {
                v.add(sTab + "         " + Thd.getCallerName(callers.elementAt(i)) + " [" + Thd.getCallerCount(callers.elementAt(i)) + "]");
            }
            v.add(" ");
        }
        if (!fReportedProblems) {
            v.add(sTab + "      no observations to report.");
        }
        v.add(this.html("</pre>"));
        v.add(this.html("<a href=#top>[top]</a>"));
        return v;
    }

    protected void loadExternalEvaluators(String xmlFile) {
        this._monitorDetailHelpers = new Vector();
        this._threadDetailHelpers = new Vector();
        Vector<String> classes = new Vector<String>();
        classes.add("com.ibm.ws.performance.threadanalyzer.utils.V353MonDetail");
        classes.add("com.ibm.ws.performance.threadanalyzer.utils.V353ThdDetail");
        this.logDebug("*Analysis helper classes*");
        for (int i = 0; i < classes.size(); ++i) {
            String clsNm = (String)classes.elementAt(i);
            clsNm = clsNm.replace('/', '.');
            try {
                this.logDebug(_sTab + clsNm);
                Class<?> cls = Class.forName(clsNm);
                Method[] m = cls.getDeclaredMethods();
                for (int j = 0; j < m.length; ++j) {
                    Class<?>[] params;
                    String methodType = "unknown";
                    if (m[j].getName().equals("setProps") && (params = m[j].getParameterTypes()).length == 2 && params[0].getName().equals("com.ibm.ws.performance.threadanalyzer.AnalyzerEnv")) {
                        Class<?> retType = m[j].getReturnType();
                        int modifiers = m[j].getModifiers();
                        if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && retType.getName().equals("void")) {
                            if (params[1].getName().equals("com.ibm.ws.performance.threadanalyzer.Thd")) {
                                methodType = "Thd";
                                this._threadDetailHelpers.add(m[j]);
                            } else if (params[1].getName().equals("com.ibm.ws.performance.threadanalyzer.Monitor")) {
                                methodType = "Monitor";
                                this._monitorDetailHelpers.add(m[j]);
                            }
                        }
                    }
                    if (!methodType.equals("Thd") && !methodType.equals("Monitor")) continue;
                    this.logDebug("      " + m[j].toString());
                    this.logDebug("      method type: " + methodType);
                }
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                this.logErr("      WARNING: " + clsNm + " described in detail XML not found.");
            }
        }
    }

    private void rptOut(String msg) {
        this._rptOut.println(this.html("<pre>") + msg + this.html("</pre>"));
    }

    private void rptOut2(String msg) {
        this._rptOut.println(msg);
    }

    private void rptOut2() {
        this._rptOut.println();
    }

    private void rptOut() {
        this._rptOut.println(this.html("<br>"));
    }

    private void logOut(String msg) {
        System.err.println(msg);
    }

    private void logErr(String msg) {
        System.err.println(msg);
    }

    private void logWarning(String msg) {
        if (this._logLevel >= 1) {
            System.err.println("WARNING: " + msg);
        }
    }

    private void logDebug(String msg) {
        if (this._logLevel >= 4) {
            System.err.println("DEBUG: " + msg);
        }
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    private String html(String sHtml) {
        if (this._fHtml) {
            return sHtml;
        }
        return "";
    }

    private String format(int minCol, int maxCol, String sIn) {
        String sOut = "";
        String sCur = "";
        int curCol = 1;
        StringTokenizer st = new StringTokenizer(sIn, " \t\n");
        while (st.hasMoreTokens()) {
            while (++curCol < minCol) {
                sOut = sOut + " ";
            }
            sCur = st.nextToken();
            if ((curCol += sCur.length()) > minCol) {
                sOut = sOut + " ";
                ++curCol;
            }
            sOut = sOut + sCur;
            if (curCol < maxCol) continue;
            curCol = 1;
            sOut = sOut + "\r\n";
        }
        return sOut;
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
    }

    public void setAnalysisType() {
        String analysis = DumpParser.getArg("analyze");
        int level = 0;
        if (analysis.equalsIgnoreCase("all")) {
            level = -1;
        }
        if (analysis.equalsIgnoreCase("was")) {
            level = 3;
        }
        if (analysis.equalsIgnoreCase("servlet")) {
            level = 1;
        }
        if (analysis.equalsIgnoreCase("ejb")) {
            level = 2;
        }
        if (analysis.equalsIgnoreCase("other")) {
            level = 32768;
        }
        if (level != 0) {
            this._analysisType = level;
        }
    }

    protected static String formattedVersion() {
        String sRet = null;
        sRet = "" + _majorVersion + "." + _minorVersion;
        if (_majorVersion < 1) {
            sRet = sRet + " (pre-release INTERNAL USE ONLY)";
        }
        return sRet;
    }

    public int getWebWaiting() {
        return this._webWaitThreads;
    }

    public int getWebWorking() {
        return this._workingWebThreads;
    }

    public int getOrbWaiting() {
        return this._orbWaitThreads;
    }

    public int getOrbWorking() {
        return this._workingOrbThreads;
    }

    public int getOthers() {
        return this._unknownThreads;
    }

    public int getTotal() {
        return this._totThreads;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(_curVersion);
        out.writeInt(this._totThreads);
        out.writeInt(this._webWaitThreads);
        out.writeInt(this._orbWaitThreads);
        out.writeInt(this._workingOrbThreads);
        out.writeInt(this._workingWebThreads);
        out.writeInt(this._unknownThreads);
        out.writeInt(this._analysisType);
        out.writeInt(this._logLevel);
        out.writeBoolean(this._fHtml);
        int thdCount = this._threads.size();
        out.writeInt(thdCount);
        Enumeration e = this.getThreadEnum();
        Thd thd = this.getNextThread(e);
        while (thd != null) {
            thd.writeExternal(out);
            thd = this.getNextThread(e);
        }
        int monCount = this._monitors.size();
        out.writeInt(monCount);
        e = this.getMonitorEnum();
        Monitor m = this.getNextMonitor(e);
        while (m != null) {
            m.writeExternal(out);
            m = this.getNextMonitor(e);
        }
        this._env.writeExternal(out);
        out.writeObject(this._inputFilename);
        out.writeInt(this._threadsMissingStacks);
        this._threadDump.writeExternal(out);
        out.writeObject(this._displayName);
        out.writeObject(this._description);
        out.writeObject(this.dumpParserClassName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._version = in.readInt();
        this._totThreads = in.readInt();
        this._webWaitThreads = in.readInt();
        this._orbWaitThreads = in.readInt();
        this._workingOrbThreads = in.readInt();
        this._workingWebThreads = in.readInt();
        this._unknownThreads = in.readInt();
        this._analysisType = in.readInt();
        in.readInt();
        this._fHtml = in.readBoolean();
        int thdCount = in.readInt();
        if (this._threads == null) {
            this._threads = new Hashtable();
        }
        for (int i = 0; i < thdCount; ++i) {
            Thd thd = new Thd();
            thd.readExternal(in);
            this._threads.put(thd.getThreadId(), thd);
        }
        int monCount = in.readInt();
        if (this._monitors == null) {
            this._monitors = new Hashtable();
        }
        for (int i = 0; i < monCount; ++i) {
            Monitor mon = new Monitor();
            mon.readExternal(in);
            this._monitors.put(mon.getName(), mon);
        }
        this._env = new AnalyzerEnv();
        this._env.readExternal(in);
        this._inputFilename = (String)in.readObject();
        this._threadsMissingStacks = in.readInt();
        if (this._threadDump == null) {
            this._threadDump = new ThreadDump();
        }
        this._threadDump.readExternal(in);
        this._displayName = (String)in.readObject();
        this._description = (String)in.readObject();
        this.dumpParserClassName = this._version >= 2 ? (String)in.readObject() : null;
        this.fixupIdRefs();
    }

    public Hashtable getThreads() {
        return this._threads;
    }

    public Hashtable getMonitors() {
        return this._monitors;
    }

    public ThreadDump getThreadDump() {
        return this._threadDump;
    }

    public void setDeadLockResults(Vector dlr) {
        this.deadlockResults = dlr;
    }

    public void setDeadLockExists(boolean dle) {
        this.deadlockExists = dle;
    }

    public boolean isDeadLockExists() {
        return this.deadlockExists;
    }

    public void setDumpParserClassName(String dpcn) {
        this.dumpParserClassName = dpcn;
    }

    public String getDumpParserClassName() {
        return this.dumpParserClassName;
    }

    public String getDumpParserClassNameFromDumpData() {
        int file_type = DumpParser.getDumpParserTypeFromDumpData(this);
        DumpParser d = DumpParser.createParser(file_type, null);
        if (d != null) {
            return d.getClass().getName();
        }
        return null;
    }
}

