/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;

public class TAProject
implements Externalizable {
    private int _version = _curVersion;
    private static int _curVersion = 3;
    private Vector _myDumpDatas = new Vector();
    protected String _description = new String("");
    protected int _uniqueId = 0;
    transient boolean modified = false;

    public String getDescription() {
        return this._description;
    }

    public int getUniqueId() {
        return ++this._uniqueId;
    }

    public void setDescription(String description) {
        if (!description.equals(this._description)) {
            this.modified = true;
        }
        this._description = description;
    }

    public Enumeration getDumps() {
        return this._myDumpDatas.elements();
    }

    public void addDump(DumpData dump) {
        this._myDumpDatas.add(dump);
        this.modified = true;
    }

    public DumpData getDump(int i) {
        if (i < this._myDumpDatas.size()) {
            return (DumpData)this._myDumpDatas.elementAt(i);
        }
        return null;
    }

    public void deleteDump(String dumpName) {
        int found = -1;
        for (int i = 0; i < this._myDumpDatas.size(); ++i) {
            if (!((DumpData)this._myDumpDatas.elementAt(i)).getDisplayName().equals(dumpName)) continue;
            found = i;
        }
        if (found != -1) {
            this.deleteDump(found);
            this.modified = true;
        }
    }

    public void changeName(String old, String newName) {
        int found = -1;
        for (int i = 0; i < this._myDumpDatas.size(); ++i) {
            if (!((DumpData)this._myDumpDatas.elementAt(i)).getDisplayName().equals(old)) continue;
            found = i;
        }
        if (found != -1) {
            ((DumpData)this._myDumpDatas.elementAt(found)).setDisplayName(newName);
            this.modified = true;
        }
    }

    public String getDumpDescrip(String old) {
        int found = -1;
        for (int i = 0; i < this._myDumpDatas.size(); ++i) {
            if (!((DumpData)this._myDumpDatas.elementAt(i)).getDisplayName().equals(old)) continue;
            found = i;
        }
        if (found != -1) {
            return ((DumpData)this._myDumpDatas.elementAt(found)).getDescription();
        }
        return "";
    }

    public void setDumpDescrip(String old, String descrip) {
        int found = -1;
        for (int i = 0; i < this._myDumpDatas.size(); ++i) {
            if (!((DumpData)this._myDumpDatas.elementAt(i)).getDisplayName().equals(old)) continue;
            found = i;
        }
        if (found != -1) {
            ((DumpData)this._myDumpDatas.elementAt(found)).setDescription(descrip);
            this.modified = true;
        }
    }

    public boolean doesNameExist(String dumpName) {
        int found = -1;
        for (int i = 0; i < this._myDumpDatas.size(); ++i) {
            if (!((DumpData)this._myDumpDatas.elementAt(i)).getDisplayName().equals(dumpName)) continue;
            found = i;
        }
        return found != -1;
    }

    public int numNames(String dumpName) {
        int found = 0;
        String origName = null;
        for (int i = 0; i < this._myDumpDatas.size(); ++i) {
            origName = ((DumpData)this._myDumpDatas.elementAt(i)).getDisplayName();
            if (origName.indexOf("- #") != -1) {
                origName = origName.substring(0, origName.indexOf("- #"));
            }
            if (!origName.equals(dumpName)) continue;
            ++found;
        }
        return found;
    }

    public void deleteDump(int i) {
        if (i < this._myDumpDatas.size()) {
            this._myDumpDatas.remove(i);
        }
    }

    public void writeTo(String fileName) throws Exception {
        try {
            FileOutputStream fo = new FileOutputStream(fileName);
            ObjectOutputStream so = new ObjectOutputStream(fo);
            this.writeExternal(so);
            so.flush();
            so.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static TAProject readFrom(String fileName) throws Exception {
        TAProject cnew = new TAProject();
        try {
            FileInputStream fi = new FileInputStream(fileName);
            ObjectInputStream si = new ObjectInputStream(fi);
            cnew.readExternal(si);
            si.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return cnew;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(_curVersion);
        DumpData myDumpData = null;
        int dumpCount = this._myDumpDatas.size();
        out.writeInt(dumpCount);
        for (int i = 0; i < dumpCount; ++i) {
            myDumpData = (DumpData)this._myDumpDatas.elementAt(i);
            myDumpData.writeExternal(out);
        }
        out.writeObject(this._description);
        out.writeInt(this._uniqueId);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._version = in.readInt();
        DumpData myDumpData = null;
        this._myDumpDatas = new Vector();
        int dumpCount = in.readInt();
        for (int i = 0; i < dumpCount; ++i) {
            myDumpData = new DumpData();
            myDumpData.readExternal(in);
            this._myDumpDatas.add(myDumpData);
        }
        if (this._version >= 2) {
            this._description = (String)in.readObject();
        }
        if (this._version >= 3) {
            this._uniqueId = in.readInt();
        }
        this._version = _curVersion;
    }

    public void initSetup() {
        DumpData myDumpData = null;
        for (int i = 0; i < this._myDumpDatas.size(); ++i) {
            myDumpData = (DumpData)this._myDumpDatas.elementAt(i);
            myDumpData.initAnalysis();
        }
    }

    public int getNumDumps() {
        return this._myDumpDatas.size();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean mod) {
        this.modified = mod;
    }
}

