/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.collection.framework;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutableObjectImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl;
import org.eclipse.hyades.test.collection.framework.UserConsole;

public class TestLauncher
implements IExecutionComponentStateChangeListener {
    public static void main(String[] args) {
        TestLauncher test = new TestLauncher();
        test.mainTest();
    }

    private void mainTest() {
        ExecutionEnvironmentImpl exeEnv = new ExecutionEnvironmentImpl();
        exeEnv.init();
        OrderedPropertyImpl prop = new OrderedPropertyImpl();
        prop.setName("CLASSPATH");
        if (System.getProperty("os.name").startsWith("Windows")) {
            prop.prependValue((Object)new String("E:\\Test"));
            prop.appendValue((Object)File.pathSeparator);
            prop.appendValue((Object)new String("E:\\Test\\hello"));
            exeEnv.setEnv((IOrderedProperty)prop);
            this.test01(exeEnv);
        } else {
            prop.prependValue((Object)new String("/home/eclipse/Test"));
            exeEnv.setEnv((IOrderedProperty)prop);
            this.test01Linux(exeEnv);
        }
    }

    private synchronized void runProcess(ExecutionEnvironmentImpl exeEnv, ProcessExecutableObjectImpl exeObj, boolean useConsole) {
        UserConsole u = new UserConsole();
        ProcessExecutorImpl executor = new ProcessExecutorImpl();
        exeEnv.addChild((IExecutionComponent)executor);
        executor.setExecutableObject((IExecutableObject)exeObj);
        executor.addExecutionComponentStateChangeListener((IExecutionComponentStateChangeListener)this);
        if (useConsole) {
            OutputStream stdin = executor.getStandardInputStream();
            InputStream stdout = executor.getStandardOutputStream();
            InputStream stderr = executor.getStandardErrorStream();
            u.setStdin(stdin);
            u.setStdout(stdout);
            u.setStderr(stderr);
            u.start();
        }
        executor.launch();
        int pid = new Integer(executor.getPid());
        if (pid < 0) {
            return;
        }
        if (useConsole) {
            while (executor.getProcessStatus(pid) != 4) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void test01(ExecutionEnvironmentImpl exeEnv) {
        ProcessExecutableObjectImpl exeObj = new ProcessExecutableObjectImpl();
        exeObj.init();
        exeObj.setName("Java test case #1");
        exeObj.setExe("E:\\jdk1.3.1\\bin\\java.exe");
        exeObj.setArgs("InOut");
        exeObj.setLocation("E:\\shared");
        this.runProcess(exeEnv, exeObj, true);
    }

    public void test02(ExecutionEnvironmentImpl exeEnv) {
        ProcessExecutableObjectImpl exeObj = new ProcessExecutableObjectImpl();
        exeObj.init();
        exeObj.setName("Java test case #2");
        exeObj.setExe("E:\\jdk1.3.1\\bin\\java.exe");
        exeObj.setArgs("PerformanceExample");
        exeObj.setLocation("E:\\shared");
        this.runProcess(exeEnv, exeObj, false);
    }

    public void test03(ExecutionEnvironmentImpl exeEnv) {
        ProcessExecutableObjectImpl exeObj = new ProcessExecutableObjectImpl();
        exeObj.init();
        exeObj.setName("Java test case #3");
        exeObj.setExe("E:\\jdk1.3.1\\bin\\java.exe");
        exeObj.setArgs("GetJavaProperties");
        exeObj.setLocation("E:\\shared");
        this.runProcess(exeEnv, exeObj, true);
    }

    public void test01Linux(ExecutionEnvironmentImpl exeEnv) {
        ProcessExecutableObjectImpl exeObj = new ProcessExecutableObjectImpl();
        exeObj.init();
        exeObj.setName("Java test case #1 (Linux)");
        exeObj.setExe("/opt/IBMJava2-131/bin/java");
        exeObj.setArgs("InOut");
        exeObj.setLocation("/tmp");
        this.runProcess(exeEnv, exeObj, true);
    }

    public void stateChanged(ExecutionComponentStateChangeEvent newState) {
        if (newState.getState() == 4 && newState.getComponent() instanceof IExecutor) {
            int pid = new Integer(((ProcessExecutorImpl)newState.getComponent()).getPid());
            System.out.println("Test case process completed: " + pid);
        }
    }
}

