/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class EnvironmentDialog
extends Dialog
implements SelectionListener {
    private Table _table;
    private TableViewer _tableViewer;
    private Button _editBtn;
    private Button _addBtn;
    private Button _deleteBtn;
    private ArrayList _data = new ArrayList();
    private EnvList _envList;
    private boolean _buttonEnable;
    private String _title;

    public EnvironmentDialog(Shell shell, String windowTitle, ArrayList data, boolean enable) {
        super(shell);
        this._title = windowTitle;
        this._buttonEnable = enable;
        if (data != null) {
            this._data.addAll(data);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 200;
        data.widthHint = 400;
        result.setLayoutData((Object)data);
        Label description = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        description.setLayoutData((Object)data);
        description.setText(UIPlugin.getResourceString("ENV_VAR_DESC"));
        this.initializeTable(result);
        Composite btnGroup = new Composite(result, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        btnGroup.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        btnGroup.setLayoutData((Object)data);
        this._addBtn = new Button(btnGroup, 0);
        data = new GridData();
        data.horizontalAlignment = 128;
        this._addBtn.setLayoutData((Object)data);
        this._addBtn.setText(UIPlugin.getResourceString("ADD_BUTTON"));
        this._editBtn = new Button(btnGroup, 0);
        data = new GridData();
        data.horizontalAlignment = 128;
        this._editBtn.setLayoutData((Object)data);
        this._editBtn.setText(UIPlugin.getResourceString("EDIT_BUTTON"));
        this._deleteBtn = new Button(btnGroup, 0);
        data = new GridData();
        data.horizontalAlignment = 128;
        this._deleteBtn.setLayoutData((Object)data);
        this._deleteBtn.setText(UIPlugin.getResourceString("DELETE_TEXT"));
        this._table.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._deleteBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.setEnabled(this._buttonEnable);
        this._deleteBtn.setEnabled(false);
        this._editBtn.setEnabled(false);
        return result;
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this._table.setLayout((Layout)layout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{UIPlugin.getResourceString("VARIABLE_TEXT"), UIPlugin.getResourceString("VALUE_TEXT")};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(280, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        boolean ncolumns = false;
        for (int i = 0; i < headers.length; ++i) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
        }
    }

    protected void initializeTable(Composite parent) {
        this._table = new Table(parent, 68356);
        this._table.setLinesVisible(false);
        this._table.setLayoutData((Object)GridUtil.createFill());
        this._tableViewer = new TableViewer(this._table);
        this.createColumns();
        EnvContentProvider provider = new EnvContentProvider(this._tableViewer);
        this._tableViewer.setContentProvider((IContentProvider)new EnvContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new EnvLabelProvider());
        this._envList = new EnvList(provider);
        this.populateTable();
        this._tableViewer.setInput((Object)this._envList);
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void okPressed() {
        this._data.clear();
        for (int idx = 0; idx < this._envList.getSize(); ++idx) {
            this._data.add(this._envList.getElementAt(idx));
        }
        super.okPressed();
    }

    private void populateTable() {
        for (int idx = 0; idx < this._data.size(); ++idx) {
            this._envList.add((EnvTableElement)this._data.get(idx));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int idx;
        if (e.widget == this._addBtn) {
            EditDialog dialog = new EditDialog(this.getShell(), null, null);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                EnvTableElement elem = new EnvTableElement(dialog.name(), dialog.value());
                if (elem.name() != "") {
                    this._envList.add(elem);
                }
                this._tableViewer.refresh();
            }
        } else if (e.widget == this._editBtn) {
            int idx2 = this._table.getSelectionIndex();
            if (idx2 != -1) {
                EnvTableElement elem = (EnvTableElement)this._envList.getElementAt(idx2);
                EditDialog dialog = new EditDialog(this.getShell(), elem.name(), elem.value());
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    elem.value(dialog.value());
                    elem.name(dialog.name());
                    this._tableViewer.refresh();
                }
            }
        } else if (e.widget == this._deleteBtn && (idx = this._table.getSelectionIndex()) != -1) {
            this._envList.removeElementAt(idx);
            this._tableViewer.refresh();
        }
        idx = this._table.getSelectionIndex();
        this._editBtn.setEnabled(idx != -1 && this._buttonEnable);
        this._deleteBtn.setEnabled(idx != -1 && this._buttonEnable);
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private String _value;
        private Text _nameText;
        private Text _valueText;

        public EditDialog(Shell shell, String name, String value) {
            super(shell);
            this._name = name;
            this._value = value;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(UIPlugin.getResourceString("ENV_VARIABLE"));
        }

        public void name(String name) {
            this._name = name;
        }

        public String name() {
            return this._name;
        }

        public void value(String value) {
            this._value = value;
        }

        public String value() {
            return this._value;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.heightHint = 50;
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString("VAR_NAME"));
            this._nameText = new Text(result, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString("VAR_VALUE"));
            this._valueText = new Text(result, 2048);
            this._valueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._nameText.addModifyListener((ModifyListener)this);
            this._valueText.addModifyListener((ModifyListener)this);
            if (this._name != null) {
                this._nameText.setText(this._name);
            }
            if (this._value != null) {
                this._valueText.setText(this._value);
            }
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if ((e.widget == this._nameText || e.widget == this._valueText) && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._nameText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            this._value = this._valueText.getText().trim();
            super.okPressed();
        }
    }

    class EnvLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Viewer viewer, Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((EnvTableElement)element).name();
            }
            if (columnIndex == 1) {
                return ((EnvTableElement)element).value();
            }
            return "";
        }

        public String getColumnText(Viewer viewer, Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((EnvTableElement)element).name();
            }
            if (columnIndex == 1) {
                return ((EnvTableElement)element).value();
            }
            return "";
        }
    }

    class EnvContentProvider
    implements IStructuredContentProvider {
        private TableViewer _viewer;
        protected EnvTableElement fChangedElement;

        public EnvContentProvider(TableViewer tableViewer) {
            this._viewer = tableViewer;
        }

        public void dispose() {
        }

        public void elementChanged(EnvTableElement changedElement, String changedProperty) {
            this.fChangedElement = changedElement;
            this._viewer.getControl().getDisplay().asyncExec(new Runnable(this){
                private final /* synthetic */ EnvContentProvider this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    EnvContentProvider.access$000(this.this$1).refresh((Object)this.this$1.fChangedElement);
                }
            });
        }

        public Object[] getElements(Object parent) {
            return ((EnvList)parent).getValues().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        static /* synthetic */ TableViewer access$000(EnvContentProvider x0) {
            return x0._viewer;
        }
    }

    class EnvList
    implements IBasicPropertyConstants {
        ArrayList _values = new ArrayList();
        EnvContentProvider _listener;

        public EnvList(EnvContentProvider listener) {
            this._listener = listener;
        }

        public void add(EnvTableElement element) {
            this.add(element, -1);
        }

        public void add(EnvTableElement element, int index) {
            if (index < 0) {
                this._values.add(element);
            } else {
                this._values.add(index, element);
            }
        }

        public void fireElementChanged(EnvTableElement changedElement, String changedProperty) {
            this._listener.elementChanged(changedElement, changedProperty);
        }

        public Object getElementAt(int index) {
            return this._values.get(index);
        }

        public ArrayList getValues() {
            return this._values;
        }

        public int getSize() {
            return this._values.size();
        }

        public void removeAll() {
            this._values.clear();
        }

        public Object removeElementAt(int idx) {
            Object element = this._values.get(idx);
            if (element == null) {
                return null;
            }
            this._values.remove(element);
            return element;
        }
    }
}

