/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.hyades.execution.recorder.http.remote.ClientSideReader;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;
import org.eclipse.hyades.execution.recorder.http.remote.PeekSocket;
import org.eclipse.hyades.execution.recorder.http.remote.SSLCheckClass;
import org.eclipse.hyades.execution.recorder.http.remote.ServerSideReader;

public class ClientSideReaderSOCKS
extends ClientSideReader {
    public static final String ERROR_SSL_REQUEST_MADE = "-1";
    public static final String ERROR_NO_TESTKEYS = "-2";
    static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
    static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");

    ClientSideReaderSOCKS(PeekSocket peekSocket, PacketWriter packetWriter, String string) {
        super(peekSocket, packetWriter, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        byte[] byArray = new byte[]{21, 3, 0, 0, 2, 2, 10};
        if (isSSLClassAvailable == -1 && (isSSLClassAvailable = this.findSSLClass()) == 1) {
            foundTestKeys = this.checkForTestKeys();
        }
        this.setName("ClientSideReaderSOCKS-Conn:" + this.iConnection);
        try {
            byte[] byArray2 = new byte[this.client.getReceiveBufferSize()];
            bl = this.processSocksRequest();
            if (bl) {
                this.bSecure = this.checkSSLByte();
                if (this.bSecure) {
                    if (isSSLClassAvailable != 1) {
                        this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_SSL_REQUEST_MADE);
                        return;
                    }
                    if (!foundTestKeys) {
                        this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_NO_TESTKEYS);
                        return;
                    }
                    SSLCheckClass sSLCheckClass = new SSLCheckClass(this, this.keyFile);
                    sSLCheckClass.makeSecureConnection();
                } else {
                    string = this.makeRegularConnection();
                }
                while ((n = this.from_client.read(byArray2)) != -1) {
                    ClientSideReaderSOCKS.yield();
                    this.bNoPrintToServer = false;
                    boolean bl3 = false;
                    String string2 = new String(byArray2, 0, n);
                    bl2 = true;
                    if (this.bSecure) {
                        this.packetWriter.writePacket(this.bSecure, true, this.connectionNumber, byArray2, n);
                        if (!this.bNoPrintToServer) {
                            this.to_server.write(byArray2, 0, n);
                            this.to_server.flush();
                        }
                    }
                    if (this.bSecure) continue;
                    this.packetWriter.writePacket(this.bSecure, true, this.connectionNumber, string2.getBytes(), string2.getBytes().length);
                    if (this.bNoPrintToServer || string2.getBytes().length <= 0) continue;
                    this.to_server.write(string2.getBytes(), 0, string2.getBytes().length);
                    this.to_server.flush();
                }
            }
            if (this.httpServer != null) {
                this.httpServer.setSoLinger(false, 0);
                if (!bl2) {
                    if (!this.httpServer.isClosed()) {
                        this.httpServer.close();
                    }
                } else if (!this.httpServer.isOutputShutdown()) {
                    if (this.bSecure) {
                        this.to_server.write(byArray, 0, 7);
                        this.to_server.flush();
                    } else {
                        this.httpServer.shutdownOutput();
                    }
                }
            }
            ClientSideReaderSOCKS.yield();
            return;
        }
        catch (Exception exception) {
            boolean bl4 = false;
            try {
                if (this.httpServer != null) {
                    if (!bl2) {
                        if (!this.httpServer.isClosed()) {
                            this.httpServer.close();
                        }
                    } else if (!this.httpServer.isOutputShutdown()) {
                        if (this.bSecure) {
                            this.to_server.write(byArray, 0, 7);
                            this.to_server.flush();
                        } else {
                            this.httpServer.shutdownOutput();
                        }
                    }
                }
                ClientSideReaderSOCKS.yield();
                this.serverReader.ssrBuffer = null;
                return;
            }
            catch (IOException iOException) {
                String string3 = iOException.getMessage();
                if (string3.indexOf("Stream closed") >= 0) return;
                if (string3.indexOf("Socket closed") >= 0) return;
                if (string3.indexOf("JVM_recv in socket input") >= 0) return;
                if (string3.indexOf("onnection closed") >= 0) return;
                if (string3.indexOf("socket closed") >= 0) return;
                if (string3.indexOf("onnection reset") >= 0) return;
                if (string3.indexOf("Socket is closed") >= 0) return;
                this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + " : " + exception.getLocalizedMessage());
            }
        }
    }

    private boolean processSocksRequest() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        byte[] byArray = new byte[4];
        boolean bl2 = false;
        InetAddress inetAddress = null;
        try {
            byte[] byArray2 = new byte[this.client.getReceiveBufferSize()];
            n = this.from_client.read(byArray2);
            if (n < 8) {
                bl = false;
            } else {
                int n5 = 0;
                block11: for (n5 = 0; n5 < 8; ++n5) {
                    Byte by = new Byte(byArray2[n5]);
                    switch (n5) {
                        case 0: {
                            n3 = by.intValue();
                            continue block11;
                        }
                        case 1: {
                            n4 = by.intValue();
                            continue block11;
                        }
                        case 2: {
                            int n6 = 0;
                            n6 = by.intValue();
                            if (n6 < 0) {
                                n6 += 256;
                            }
                            n2 = n6 * 256;
                            continue block11;
                        }
                        case 3: {
                            int n7 = 0;
                            n7 = by.intValue();
                            if (n7 < 0) {
                                n7 += 256;
                            }
                            n2 += n7;
                            continue block11;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            byArray[n5 - 4] = byArray2[n5];
                        }
                    }
                }
                string = ClientSideReaderSOCKS.IP4ByteToString(byArray);
                inetAddress = InetAddress.getByName(string);
                this.destServer = inetAddress.getHostName();
                this.serverPort = n2;
                this.httpServer = new Socket(inetAddress, n2);
                if (this.httpServer != null) {
                    this.respondToClient(true);
                    bl = true;
                } else {
                    bl = false;
                    this.respondToClient(false);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(1, "Error closing Client" + iOException + " Connection: " + this.iConnection);
            }
        }
        return bl;
    }

    private static String IP4ByteToString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < 4; ++i) {
            string = byArray[i] >= 0 ? string + String.valueOf(byArray[i]) : string + String.valueOf(256 + byArray[i]);
            if (i >= 3) continue;
            string = string + ".";
        }
        return string;
    }

    private void respondToClient(boolean bl) {
        byte[] byArray = new byte[8];
        byArray[0] = 0;
        byArray[1] = bl ? 90 : 91;
        try {
            this.to_client.write(byArray, 0, 8);
            this.to_client.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String makeRegularConnection() {
        String string = null;
        boolean bl = false;
        try {
            this.packetWriter.writeOpenConnectionInfo(this.bSecure, this.iConnection, this.destServer, this.serverPort, this.client, this.httpServer, null, null);
            this.to_server = this.httpServer.getOutputStream();
            this.from_server = this.httpServer.getInputStream();
            this.serverReader = new ServerSideReader(this.client, this.httpServer, this.from_server, this.to_client, this.packetWriter, this.connectionNumber, this.bSecure, this.httpServer.getReceiveBufferSize());
            this.serverReader.start();
        }
        catch (Exception exception) {
            this.packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
            try {
                if (!this.client.isClosed()) {
                    this.client.close();
                }
                string = null;
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + ": " + iOException);
            }
        }
        return string;
    }

    public int findSSLClass() {
        int n = -1;
        try {
            Class<?> clazz = Class.forName("javax.net.ssl.SSLSocket");
            n = 1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            n = 0;
        }
        return n;
    }

    boolean checkSSLByte() {
        boolean bl = false;
        int n = 0;
        try {
            n = this.client.peek();
        }
        catch (IOException iOException) {
            this.packetWriter.writeRecorderMessage(2, "exception checking for SSL Connection: " + this.iConnection + iOException);
        }
        if (n == 128 || n == 20 || n == 21 || n == 22 || n == 23) {
            bl = true;
            this.bSecure = true;
        } else {
            this.bSecure = false;
            bl = false;
        }
        return bl;
    }
}

