/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.ReferenceQuery;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.GetByQueryCommand;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class GetReferenceQuery
extends GetByQueryCommand {
    protected ReferenceQuery query;
    protected Integer id;

    public GetReferenceQuery(JDBCHelper helper, DBMap map, DatabaseType type, ReferenceQuery query, Integer id, WeakObjectCache cache) {
        super(helper, map, type, cache);
        this.query = query;
        this.id = id;
    }

    public Object execute() throws Exception {
        if (this.query.getEObject() == null || this.query.getEReference() == null) {
            return null;
        }
        List referenced = this.getReferencedObjects(this.id);
        return this.toArray(referenced);
    }

    protected List getReferencedObjects(Integer id) throws Exception {
        List ids = this.getIdsOfReferencedObjects(id);
        return this.getObjects(ids);
    }

    protected List getIdsOfReferencedObjects(Integer id) throws Exception {
        int[] ids = new int[]{id};
        PerfUtil p = new PerfUtil("GetReferenceQuery.getIdsOfReferencedObjects()", true);
        DBCommand getIds = DBCommandFactory.INSTANCE.createGetIdsOfReferencedObjects(this.helper, this.dbMap, this.type, ids, this.query.getEReference(), true);
        int[][] referencedIds = (int[][])getIds.execute();
        ArrayList<Integer> idsList = new ArrayList<Integer>();
        if (referencedIds[0] == null) {
            return idsList;
        }
        for (int i = 0; i < referencedIds[0].length; ++i) {
            idsList.add(new Integer(referencedIds[0][i]));
        }
        p.stopAndPrintStatus("id=" + id + ", size=" + idsList.size());
        return idsList;
    }

    protected List getObjects(List ids) throws Exception {
        return this.getObjects(this.query.getEReference().getEReferenceType(), this.prune(ids), this.query.isSetReferences(), this.query.getNotLoadedClasses());
    }

    protected List prune(List ids) throws Exception {
        int lower = this.query.getLower();
        int upper = this.query.getUpper();
        int lastIndex = ids.size();
        upper = upper == -1 || upper >= lastIndex ? lastIndex : ++upper;
        if (lower >= lastIndex) {
            return new ArrayList();
        }
        return ids.subList(lower, upper);
    }
}

