/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;

public class UpdateLargestDatabaseId
extends DBCommand {
    protected int largestId;
    protected Table idTable;

    public UpdateLargestDatabaseId(JDBCHelper helper, DBMap map, int id) {
        super(helper, map);
        this.largestId = id;
        this.idTable = map.getIdTable();
    }

    public Object execute() throws Exception {
        PerfUtil p = new PerfUtil("UpdateLargestDatabaseId.execute id=" + this.largestId, true);
        if (this.idTable == null) {
            return null;
        }
        int currentId = this.getCurrentId();
        if (currentId == 0) {
            this.addId();
        } else {
            this.updateId(currentId);
        }
        p.stopAndPrintStatus();
        return null;
    }

    protected int getCurrentId() throws Exception {
        DBCommand command = DBCommandFactory.INSTANCE.createGetLargestDatabaseId(this.helper, this.dbMap);
        Integer id = (Integer)command.execute();
        return id == null ? 0 : id;
    }

    protected void addId() throws Exception {
        String insert = this.createInsertStatement();
        this.helper.executeUpdateStatement(insert);
    }

    protected String createInsertStatement() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ");
        buffer.append(this.addQuotes(this.idTable.getName()));
        buffer.append(" (");
        buffer.append(this.addQuotes(((Column)this.idTable.getColumns().get(0)).getName()));
        buffer.append(") VALUES (");
        buffer.append(this.largestId);
        buffer.append(")");
        return buffer.toString();
    }

    protected void updateId(int current) throws Exception {
        String update = this.createUpdateStatement(current);
        this.helper.executeUpdateStatement(update);
    }

    protected String createUpdateStatement(int current) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ");
        buffer.append(this.addQuotes(this.idTable.getName()));
        buffer.append(" SET ");
        Column id = (Column)this.idTable.getColumns().get(0);
        buffer.append(this.addQuotes(id.getName()));
        buffer.append(" = ");
        buffer.append(this.largestId);
        buffer.append(" WHERE ");
        buffer.append(this.addQuotes(id.getName()));
        buffer.append(" = ");
        buffer.append(current);
        return buffer.toString();
    }
}

