/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.internal.execution.local.common.ActiveAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.GetPropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.KillProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessExitedCommand;
import org.eclipse.hyades.internal.execution.local.common.PropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.RegisteredProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.NotImplementedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.SecureConnectionImpl;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;

class NodeImpl
implements Node {
    protected String _name;
    protected InetAddress[] _addr;
    protected Vector _listeners = new Vector(10);
    protected Connection _connection;
    protected Application _application;
    private User _user;
    private Object propLock = new Object();
    private ISecureClientParameters _securityParms = null;
    protected Hashtable _processes = new Hashtable(300);
    protected SetNVPairCommand[] props = null;
    private ProcessListener _processListener = null;
    private long _listProcessesWaitingCommandCount = 0L;
    private Object _listProcessesLock = new Object();

    public NodeImpl(String name, InetAddress addr) {
        this._name = name;
        try {
            this._addr = InetAddress.getAllByName(addr.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this._processListener = new ProcessListener(){

            public synchronized void processLaunched(Process process) {
                try {
                    Long key = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(key);
                    NodeImpl.this._processes.put(key, process);
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }

            public synchronized void processExited(Process process) {
                try {
                    Long key = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(key);
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }
        };
    }

    public NodeImpl(String name, InetAddress[] addr) {
        this._name = name;
        this._addr = addr;
        this._processListener = new ProcessListener(){

            public synchronized void processLaunched(Process process) {
                try {
                    Long key = new Long(process.getProcessId());
                    if (!NodeImpl.this._processes.containsKey(key)) {
                        NodeImpl.this._processes.put(key, process);
                    }
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }

            public synchronized void processExited(Process process) {
                try {
                    Long key = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(key);
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }
        };
    }

    public void killProcess(Process process) throws InactiveProcessException, NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        if (!process.isActive()) {
            throw new InactiveProcessException();
        }
        ControlMessage message = new ControlMessage();
        KillProcessCommand command = new KillProcessCommand();
        command.setProcessId(Long.parseLong(process.getProcessId()));
        message.appendCommand(command);
        try {
            this._connection.sendMessage(message, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement command) {
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void shutdown(long delay) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public void reboot(long delay) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public Enumeration listMonitors() throws NotConnectedException {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration listProcesses() throws NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        NodeImpl node = this;
        ControlMessage message = new ControlMessage();
        QueryProcessListCommand command = new QueryProcessListCommand();
        message.appendCommand(command);
        ConnectionListener connectionListener = new ConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connectionClosed(Connection connection) {
                Object object = NodeImpl.this._listProcessesLock;
                synchronized (object) {
                    NodeImpl.this._listProcessesLock.notifyAll();
                }
            }
        };
        Object object = this._listProcessesLock;
        synchronized (object) {
            this._connection.addConnectionListener(connectionListener);
            try {
                this._connection.sendMessage(message, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement command) {
                        switch ((int)command.getTag()) {
                            case 33: {
                                RegisteredProcessListCommand qs = (RegisteredProcessListCommand)command;
                                long[] list = qs.getProcessList();
                                long entries = list.length;
                                Enumeration enumeration = NodeImpl.this._processes.elements();
                                while (enumeration.hasMoreElements()) {
                                    long offset;
                                    long pid = 0L;
                                    Process current = (Process)enumeration.nextElement();
                                    try {
                                        pid = Long.parseLong(current.getProcessId());
                                    }
                                    catch (InactiveProcessException e) {
                                        continue;
                                    }
                                    for (offset = 0L; offset < entries; ++offset) {
                                        if (pid != list[(int)offset]) continue;
                                        if (current.isActive()) break;
                                        offset = entries;
                                    }
                                    if (offset != entries) continue;
                                    NodeImpl.this._processes.remove(new Long(pid));
                                    try {
                                        ProcessExitedCommand pec = new ProcessExitedCommand();
                                        pec.setProcessId(pid);
                                        ((ProcessImpl)current).handleCommand(pec);
                                    }
                                    catch (ClassCastException e) {}
                                }
                                if (entries == 0L) {
                                    Object pid = NodeImpl.this._listProcessesLock;
                                    synchronized (pid) {
                                        NodeImpl.this._listProcessesLock.notify();
                                        break;
                                    }
                                }
                                ControlMessage msg = new ControlMessage();
                                int i2 = 0;
                                while ((long)i2 < entries) {
                                    QueryAgentListCommand qal = new QueryAgentListCommand();
                                    qal.setProcessId(list[i2]);
                                    msg.appendCommand(qal);
                                    ++i2;
                                }
                                try {
                                    Object i2 = NodeImpl.this._listProcessesLock;
                                    synchronized (i2) {
                                        NodeImpl.this._listProcessesWaitingCommandCount = entries;
                                    }
                                    NodeImpl.this._connection.sendMessage(msg, new CommandHandler(this){
                                        private final /* synthetic */ 5 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void incommingCommand(Node node, CommandElement command) {
                                            switch ((int)command.getTag()) {
                                                case 34: {
                                                    ActiveAgentListCommand aal = (ActiveAgentListCommand)command;
                                                    Long processId = new Long(aal.getProcessId());
                                                    Process process = (Process)5.access$200(this.this$1)._processes.get(processId);
                                                    if (process == null) {
                                                        process = new ProcessImpl(node, aal.getProcessName(), aal.getProcessId());
                                                        try {
                                                            process.addProcessListener(NodeImpl.access$300(5.access$200(this.this$1)));
                                                        }
                                                        catch (ClassCastException e) {
                                                            // empty catch block
                                                        }
                                                        5.access$200(this.this$1)._processes.put(processId, process);
                                                    } else if (!process.getExecutable().equals(aal.getProcessName()) && !aal.getProcessName().equals("unknown")) {
                                                        ProcessExitedCommand pec = new ProcessExitedCommand();
                                                        pec.setProcessId(aal.getProcessId());
                                                        ((ProcessImpl)process).handleCommand(pec);
                                                        5.access$200(this.this$1)._processes.remove(processId);
                                                        process = new ProcessImpl(node, aal.getProcessName(), aal.getProcessId());
                                                        try {
                                                            process.addProcessListener(NodeImpl.access$300(5.access$200(this.this$1)));
                                                        }
                                                        catch (ClassCastException e) {
                                                            // empty catch block
                                                        }
                                                        5.access$200(this.this$1)._processes.put(processId, process);
                                                    }
                                                    ((ProcessImpl)process).removeAllAgents();
                                                    String[] agents = aal.getAgents();
                                                    for (int j = 0; j < agents.length; ++j) {
                                                        ControlMessage msg2 = new ControlMessage();
                                                        QueryAgentDetailsCommand cmd = new QueryAgentDetailsCommand();
                                                        cmd.setProcessId(aal.getProcessId());
                                                        cmd.setAgentName(agents[j]);
                                                        msg2.appendCommand(cmd);
                                                        try {
                                                            Object object = NodeImpl.access$000(5.access$200(this.this$1));
                                                            synchronized (object) {
                                                                NodeImpl.access$108(5.access$200(this.this$1));
                                                            }
                                                            5.access$200(this.this$1)._connection.sendMessage(msg2, new CommandHandler(this){
                                                                private final /* synthetic */ 6 this$2;
                                                                {
                                                                    this.this$2 = this$2;
                                                                }

                                                                /*
                                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                                 */
                                                                public void incommingCommand(Node node, CommandElement command) {
                                                                    switch ((int)command.getTag()) {
                                                                        case 40: {
                                                                            AgentDetailsCommand adc = (AgentDetailsCommand)command;
                                                                            Process processLookup = (Process)5.access$200(6.access$400(this.this$2))._processes.get(new Long(adc.getProcessId()));
                                                                            if (processLookup == null) break;
                                                                            ((ProcessImpl)processLookup).setUUID(adc.getProcessUUID());
                                                                            Agent agent = processLookup.getAgent(adc.getAgentName());
                                                                            if (agent != null) break;
                                                                            agent = new AgentImpl(processLookup, adc.getAgentName(), adc.getAgentType(), true);
                                                                            ((AgentImpl)agent).setUUID(adc.getAgentUUID());
                                                                            try {
                                                                                ((ProcessImpl)processLookup).addAgent(agent);
                                                                                agent.addAgentListener((ProcessImpl)processLookup);
                                                                                break;
                                                                            }
                                                                            catch (ClassCastException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                    }
                                                                    Object object = NodeImpl.access$000(5.access$200(6.access$400(this.this$2)));
                                                                    synchronized (object) {
                                                                        NodeImpl.access$110(5.access$200(6.access$400(this.this$2)));
                                                                        if (NodeImpl.access$100(5.access$200(6.access$400(this.this$2))) == 0L) {
                                                                            NodeImpl.access$000(5.access$200(6.access$400(this.this$2))).notify();
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                            continue;
                                                        }
                                                        catch (IOException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    break;
                                                }
                                            }
                                            Object object = NodeImpl.access$000(5.access$200(this.this$1));
                                            synchronized (object) {
                                                NodeImpl.access$110(5.access$200(this.this$1));
                                                if (NodeImpl.access$100(5.access$200(this.this$1)) == 0L) {
                                                    NodeImpl.access$000(5.access$200(this.this$1)).notify();
                                                }
                                            }
                                        }

                                        static /* synthetic */ 5 access$400(6 x0) {
                                            return x0.this$1;
                                        }
                                    });
                                    break;
                                }
                                catch (IOException e) {
                                    Object object = NodeImpl.this._listProcessesLock;
                                    synchronized (object) {
                                        NodeImpl.this._listProcessesWaitingCommandCount = 0L;
                                        NodeImpl.this._listProcessesLock.notify();
                                        break;
                                    }
                                }
                            }
                        }
                    }

                    static /* synthetic */ NodeImpl access$200(5 x0) {
                        return x0.NodeImpl.this;
                    }
                });
            }
            catch (IOException e) {
                return null;
            }
            try {
                this._listProcessesLock.wait(7000L);
                this._connection.removeConnectionListener(connectionListener);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return ((Hashtable)this._processes.clone()).elements();
    }

    public synchronized Process getProcess(String processId) {
        return (Process)this._processes.get(new Long(processId));
    }

    public InetAddress getInetAddress() {
        if (this._addr != null) {
            return this._addr[0];
        }
        return null;
    }

    public InetAddress[] getAllInetAddresses() {
        return this._addr;
    }

    public String getName() {
        return this._name;
    }

    public boolean isConnected() {
        if (this._connection != null) {
            return this._connection.isActive();
        }
        return false;
    }

    public synchronized Connection connect(int port) throws AgentControllerUnavailableException, SecureConnectionRequiredException, UntrustedAgentControllerException, LoginFailedException {
        if (this._connection == null || !this._connection.isActive()) {
            try {
                if (this._securityParms == null) {
                    this._connection = new ConnectionImpl();
                    ((ConnectionImpl)this._connection).connect(this, port);
                } else {
                    this._connection = new SecureConnectionImpl();
                    if (this._connection != null) {
                        this._connection.connect(this, port);
                    }
                }
            }
            catch (IOException e) {
                this._connection = null;
                throw new AgentControllerUnavailableException();
            }
        }
        return this._connection;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public ProcessListener getProcessListener() {
        return this._processListener;
    }

    public void setUser(User user) {
        this._user = user;
    }

    public User getUser() {
        return this._user;
    }

    public void setApplication(Application app) {
        this._application = app;
    }

    public Application getApplication() {
        return this._application;
    }

    public void setSecurityParameters(ISecureClientParameters manager) {
        this._securityParms = manager;
    }

    public ISecureClientParameters getSecurityParameters() {
        return this._securityParms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetNVPairCommand[] getPropertyValues(String name, String type) throws NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        NodeImpl node = this;
        ControlMessage message = new ControlMessage();
        GetPropertyListCommand command = new GetPropertyListCommand();
        command.setName(name);
        command.setType(type);
        message.appendCommand(command);
        Object object = this.propLock;
        synchronized (object) {
            try {
                this._connection.sendMessage(message, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement command) {
                        switch ((int)command.getTag()) {
                            case 42: {
                                PropertyListCommand qs = (PropertyListCommand)command;
                                NodeImpl.this.props = qs.getPropertyListValues();
                                Object object = NodeImpl.this.propLock;
                                synchronized (object) {
                                    NodeImpl.this.propLock.notify();
                                    break;
                                }
                            }
                        }
                    }
                });
                this.propLock.wait(10000L);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.props;
    }

    static /* synthetic */ ProcessListener access$300(NodeImpl x0) {
        return x0._processListener;
    }

    static /* synthetic */ long access$108(NodeImpl x0) {
        return x0._listProcessesWaitingCommandCount++;
    }

    static /* synthetic */ long access$110(NodeImpl x0) {
        return x0._listProcessesWaitingCommandCount--;
    }

    static /* synthetic */ long access$100(NodeImpl x0) {
        return x0._listProcessesWaitingCommandCount;
    }
}

