/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * This is the parent of the hierarchy of skeletons -- objects to which
 * remote method invocations are delegated and which then delegate the method
 * implementations to their delegate objects.
 */
public abstract class RemoteObjectSkeleton implements IRemoteObject {
	
	/**
	 * a unique identifier used to reference this skeleton (and hence
	 * the target object) 
	 */
	protected Integer uniqueId;
	
	/**
	 * the session context of a remote object is (should be) the same as
	 * that of the factory that created the remote object
	 */
	protected ISession sessionContext;
	
	/**
	 * the object for which this skeleton is providing remote execution
	 * semantics
	 */
	protected Object delegate;
	
	protected RemoteObjectSkeleton() {}

	/**
	 * Create a skeleton, associating the specified id with the instance
	 * (and hence the target object).
	 * 
	 * @param id
	 */
	public RemoteObjectSkeleton(Integer id) {
		uniqueId=id;
	}

	/**
	 * Set the unique id that identifies this instance (and hence the target
	 * object). This only needs to be done locally.
	 * 
	 * @param id
	 */
	public void setId(Integer id) {
		uniqueId=id;
	}

	/**
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#getUniqueId()
	 */
	public Integer getUniqueId() {
		return uniqueId;
	}

	/**
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#delegateRemoteCall(java.lang.Class[], java.lang.Object[], java.lang.String)
	 */
	public ReturnData delegateRemoteCall(
		Class[] argTypes,
		Object[] callArgs,
		String call)
		throws RemoteInvocationException {
		return null;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#getDelegate()
	 */
	public Object getDelegate() {
		return delegate;
	}

	/**
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#setDelegate(java.lang.Object)
	 */
	public void setDelegate(Object delegate) {
		this.delegate = delegate;
	}

	/**
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#init()
	 */
	public void init() {
	}

	/**
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#getSessionContext()
	 */
	public ISession getSessionContext() {
		return sessionContext;
	}

	/**
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#setSessionContext(org.eclipse.hyades.execution.core.ISession)
	 */
	public void setSessionContext(ISession session) {
		sessionContext = session;
	}

}
