/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A named element is any object that has a name and description.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface INamedElement{
	
	/**
	 * Returns the name of the element.
	 * 
	 * @return String
	 */	
	public String getName();

	/**
	 * Sets the name of the element.
	 * 
	 * @param name
	 */	
	public void setName(String name);

	/**
	 * Returns the description of the element.
	 * 
	 * @return String
	 */	
	public String getDescription();

	/**
	 * Sets the description of the element.
	 * 
	 * @param description
	 */	
	public void setDescription(String description);
	
	/**
	 * Returns the Id of the element.
	 * 
	 * @return String
	 */	
	public String getId();

	/**
	 * Sets the Id of the element.
	 * 
	 * @param description
	 */	
	public void setId(String id);
	
}
