/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFWaitEvent}.
 * 
 * @author akmathur
 * @since 3.0
 */
public class WaitEvent extends TimedEvent {
	
	/**
	 * @see org.eclipse.hyades.test.common.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml) {
		// No attributes at the moment, this is a tag event for the TimedEvent
		super.addXMLAttributes(xml);
	}
	/**
	 * @see org.eclipse.hyades.test.common.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot() {
		return "waitEvent";
	}
}
