/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.hyades.logging.adapter.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.ui.internal.views.*;
import org.eclipse.swt.widgets.Display;

public class TestContextListener implements IContextListener {
	
	/* Record indices */
	private int extractorIndex = 0;
	private int formatterIndex = 0;
	
	private boolean firstRecord=true;
	
	protected ContextInstanceType context;
	
	private ResultQueue queue;
	
	public TestContextListener()
	{
		super();
	}

	/**
	 * @see org.eclipse.hyades.logging.adaptor.IContextListener#preProcessEventItems(org.eclipse.hyades.logging.adaptor.IComponent, java.lang.Object[])
	 */
	public void preProcessEventItems(IComponent component, Object[] msgs) {
	}

	/**
	 * @see org.eclipse.hyades.logging.adaptor.IContextListener#postProcessEventItems(org.eclipse.hyades.logging.adaptor.IComponent, java.lang.Object[])
	 */
	public void postProcessEventItems(IComponent component, Object[] results) {
		
		final AcadGuiModel model = AcadGuiModelManager.getModel(context);
		if(model==null) {
			return;
		}
		else if(queue==null) {
			queue=model.getResultQueue();
		}

		if(component instanceof ISensor) {
			if(results != null) {
				StringBuffer buffer = new StringBuffer();
				for(int idx=0; idx<results.length; idx++)
					if(results[idx] != null) {
						buffer.append(results[idx]).append("\n");
					}
				
				if(model != null) {		
					model.setLogContent(model.getLogContent() + buffer.toString());
				}
			}
		}
		/* Each of the messages returned from the extractor need to be placed into the queue
		 * 
		 */
        else if(component instanceof IExtractor) {
			if(results != null) {
				if(model!=null) {
					for(int idx=0; idx<results.length; idx++) {
						
						/* Check if we have made it to the starting record index */
						if(results[idx] != null && ++extractorIndex >= model.getStartRecord()) {
	 							queue.insertExtractorResult(results[idx]);
	 							
	 							/* RKD:  There is ap otential problem here where the UI does not get updated
	 							 * until the entire amount of records is put in the queue. If the record count
	 							 * is greater then the queue length then the buttons may not be enabled to
	 							 * allow the user to start flushing the queue.  This results in a deadlock
	 							 * during the call to add an entry to the queue.  To circumvent this we are going
	 							 * to make sure the buttons are enabled as soon as we add our first event to
	 							 * the queue.
	 							 */
	 							if(firstRecord) {
	 								Display.getDefault().asyncExec(new Runnable() {
	 									public void run() {
	 										LogView log=LogView.getLogView(false);
	 										if(log!=null) {
	 											log.enableActions();
	 										}
	 									}
	 								});
	 								firstRecord=false;
	 							}
						}
						
					}
					
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							model.updateTemplateLog();								
						}
					});
					
				}
			}
        }
		else if(component instanceof IFormatter) {
			/* This is a result from the formatter.  Add it to the result queue */
			if(results != null) {
				if(model!=null) {
					for(int idx=0; idx<results.length; idx++) {
						
  				    /* Check if we have made it to the starting record index */
					if(results[idx] != null && ++formatterIndex >= model.getStartRecord()) {
							queue.insertFormatterResult(results[idx]);
						}
					}
				}
			}
		}
	}

	/**
	 * @see org.eclipse.hyades.logging.adaptor.IContextListener#getTargetContextUniqueIds()
	 */
	public String[] getTargetContextUniqueIds() {
		
		
		AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
		if(model == null || model.getContextInstance() == null)
		{
			context = null;
			return new String[] {};
			
		}		
		context = model.getContextInstance();
		model.setContextListener(this);
		
		return new String[] {context.getUniqueID()};
	}

	/**
	 * @return
	 */
	public ContextInstanceType getContext() {
		return context;
	}

	/**
	 * @param type
	 */
	public void setContext(ContextInstanceType type) {
		context = type;
	}	
}
