/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local.file;

import java.net.InetAddress;

import org.eclipse.hyades.execution.core.file.IFileLocation;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class FileLocationImpl implements IFileLocation {
	private String key;
	private int port;
	private InetAddress addr;
	
	public FileLocationImpl(InetAddress addr, int port, String jobKey) {
		this.addr=addr;
		this.port=port;
		this.key=jobKey;
		
	}
	
	public FileLocationImpl() {
		
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.file.IFileLocation#getInetAddress()
	 */
	public InetAddress getInetAddress() {
		return addr;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.file.IFileLocation#getPort()
	 */
	public int getPort() {
		return port;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.file.IFileLocation#getJobKey()
	 */
	public String getJobKey() {
		return key;
	}
	
	public void setInetAddress(InetAddress addr) {
		this.addr=addr;
	}
	
	public void setPort(int port) {
		this.port=port;
	}
	
	public void setJobKey(String key) {
		this.key=key;
	}
	
	
}
