/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.util;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class GraphNodeSelectionDialog extends Dialog implements ISelectionChangedListener{

	private int type;
	private List graphNodeList;
	private Table eventsTable;
	private TableViewer fTableViewer;
	private CBECommonBaseEvent selection;
	public static final int SOURCE_EVENTS = 0;
	public static final int TARGET_EVENTS = 1;
	
	public GraphNodeSelectionDialog(Shell shell, int type){
		super(shell);		
		this.type = type;
		
	}
	
	public void setInput(List input){
		graphNodeList = input;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {
		
		parent.setLayout(new GridLayout());
		Label lblMessage =  new Label(parent, SWT.NONE);
		lblMessage.setLayoutData(GridUtil.createHorizontalFill());
		getShell().setText(SDLogcPlugin.getString("STR_SELECT_DIALOG_TITLE"));
		
		String message = "";
		if(type==SOURCE_EVENTS){
			message = SDLogcPlugin.getString("STR_SELECT_SOURCE_EVENT"); 
		}else if(type==TARGET_EVENTS){
			message = SDLogcPlugin.getString("STR_SELECT_TARGET_EVENT");
		}
 
		lblMessage.setText(message);
		
		eventsTable = new Table(parent, SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL|SWT.FULL_SELECTION|SWT.MULTI);
		GridData tblData = GridUtil.createFill();
		tblData.heightHint = 75;
		tblData.widthHint = 350;	
		eventsTable.setLayoutData(tblData);
				
		TableColumn tc = new TableColumn(eventsTable, SWT.NONE);		
 		
		tc = new TableColumn(eventsTable, SWT.NONE);
		
		ColumnLayoutData c0Layout = new ColumnWeightData(150, true);
		
		ColumnLayoutData c1Layout = new ColumnWeightData(200, true);
		
		// set columns in Table layout
		TableLayout tblLayout = new TableLayout();

		tblLayout.addColumnData(c0Layout);
		tblLayout.addColumnData(c1Layout);
		eventsTable.setLayout(tblLayout);
		eventsTable.setHeaderVisible(true);
		eventsTable.setLinesVisible(true);
		
		fTableViewer= new TableViewer(eventsTable);		
		
		fTableViewer.setLabelProvider(new TableLabelProvider());
				
		fTableViewer.setContentProvider(new TableContentProvider());
		fTableViewer.addSelectionChangedListener(this);
		fTableViewer.setInput(graphNodeList);

		WorkbenchHelp.setHelp(eventsTable,ContextIds.EVENT_SELECTION_DIALOG);
		
		return super.createContents(parent);
	}

	class TableContentProvider implements IStructuredContentProvider{
	
			/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {			
			return graphNodeList.toArray();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {

		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(
			Viewer viewer,
			Object oldInput,
			Object newInput) {

		}

	}
	
	class TableLabelProvider extends LabelProvider implements ITableLabelProvider{

		
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) {

			if(columnIndex==0){
				return CBEUtils.formatCreationTime((CBECommonBaseEvent)element,LogUIPlugin.getDateTimeFormat());				
			}
			if(columnIndex==1){
				if (((CBECommonBaseEvent)element).getMsg()==null)
					return "";
				else
					return ((CBECommonBaseEvent)element).getMsg();				
			}
			
			return "";
		}
		
		
		/*
		 * @see IBaseLabelProvider#dispose()
		 */
		public void dispose() {
			super.dispose();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex) {
			// TODO Auto-generated method stub
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		IStructuredSelection sel = (IStructuredSelection)event.getSelection();
		if(sel.size()>0){
			selection = (CBECommonBaseEvent)sel.getFirstElement();
		}else{
			selection = null;
		}


	}
	
	public EObject getSelection(){
		return selection;
	}

}
