/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;


/**
 * Here is a message
 */
public class TraceSyncMessage extends SyncMessage
		implements IDateSelection, ITraceMessage, IEObjectSelection {
	
	public TRCFullMethodInvocation model;
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getMeaning()
	 */
	public int getMeaning() {
		return IDateSelection.NOW;
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getStartDate()
	 */
	public double getStartDate() {
		return model == null ? 0 : model.getEntryTime();
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getEndDate()
	 */
	public double getEndDate() {
		return getStartDate();
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection#getEObject()
	 */
	public EObject getEObject() {
		return model;
	}
}