/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class DetailSection 
extends EditorSection
{
	public static class DetailPage
	implements VerifyKeyListener, IDisposable
	{
		private DetailSection detailSection;

		public void dispose()
		{
			detailSection = null;
		}

		public Control createControl(Composite parent, FormWidgetFactory factory)
		{
			return null;
		}	
		
		public void setDetailSection(DetailSection detailSection)
		{
			this.detailSection = detailSection;
		}
		
		protected EditorForm getEditorForm()
		{
			return getDetailSection().getEditorForm();
		}
		
		protected DetailSection getDetailSection()
		{
			return detailSection;
		}
		
		public void setInput(Object object)
		{
		}

		public Object getInput()
		{
			return null;
		}

		public IStructuredSelection getStructuredSelection()
		{
			if(getInput() == null)
				return StructuredSelection.EMPTY;
			return new StructuredSelection(getInput());
		}

		public void selectReveal(ISelection selection)
		{
		}
		
		public boolean isReadOnly()
		{
			return getDetailSection().isReadOnly();
		}
		
		/**
		 * @see org.eclipse.swt.custom.VerifyKeyListener#verifyKey(org.eclipse.swt.events.VerifyEvent)
		 */
		public void verifyKey(VerifyEvent event)
		{
			getDetailSection().verifyKey(event);
		}
	}
	
	private PageBook pageBook;
	private Map pageByType;
	private Map controlByPage;
	private Composite defaultControl;
	
	private Object input;
	
	/**
	 * Constructor for DetailSection
	 * @param editorForm
	 */
	public DetailSection(EditorForm editorForm)
	{
		super(editorForm);
		setCollapsable(true);
		pageByType = new HashMap();
		controlByPage = new HashMap();
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#dispose()
	 */
	public void dispose()
	{
		input = null;
		pageByType.clear();
		controlByPage.clear();
		super.dispose();
	}
	
	public void add(Class type, DetailPage detailPage)
	{
		if(!controlByPage.isEmpty())
			return;
			
		detailPage.setDetailSection(this);
		pageByType.put(type, detailPage);
	}

	public void remove(Class type)
	{
		if(!controlByPage.isEmpty())
			return;
			
		pageByType.remove(type);
	}
	
	public boolean isEmpty()
	{
		return pageByType.isEmpty();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory factory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		composite.setLayout(gridLayout);		
		composite.setLayoutData(GridDataUtil.createFill());

		pageBook = new PageBook(composite, SWT.NONE);
		pageBook.setLayoutData(GridDataUtil.createFill());
		pageBook.setBackground(widgetFactory.getBackgroundColor());
		pageBook.addMouseListener(new MouseAdapter()
		{
			public void mousePressed(MouseEvent e)
			{
				((Control) e.widget).setFocus();
			}
		});
		pageBook.setMenu(parent.getMenu());

		defaultControl = widgetFactory.createComposite(pageBook);
		defaultControl.setLayout(new GridLayout());
		defaultControl.setLayoutData(GridDataUtil.createFill());
		
		Label label = widgetFactory.createLabel(defaultControl, TestUIPlugin.getString("NO_DETAILS")); //$NON-NLS-1$
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.verticalAlignment = GridData.VERTICAL_ALIGN_BEGINNING;
		label.setLayoutData(gridData);
		
		int maxHeight = 0;
		for (Iterator i = pageByType.entrySet().iterator(); i.hasNext();)
		{
			Map.Entry entry = (Map.Entry)i.next();
			DetailPage detailPage = (DetailPage)entry.getValue();
			Control control = detailPage.createControl(pageBook, widgetFactory);
			control.setLayoutData(GridDataUtil.createFill());
			controlByPage.put(detailPage, control);
			
			int height = control.computeSize(SWT.DEFAULT, SWT.DEFAULT, true).y;
			if(height>maxHeight)
				maxHeight = height;
		}
		((GridData)pageBook.getLayoutData()).heightHint = maxHeight;
		pageBook.layout(true);
		
		return composite;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		input = object;
		DetailPage detailPage = getDetailPage(object);
		if(detailPage == null)
		{
			pageBook.showPage(defaultControl);
		}
		else
		{	
			detailPage.setInput(input);
			pageBook.showPage((Control)controlByPage.get(detailPage));
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return input;
	}


	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection()
	{
		DetailPage detailPage = getDetailPage(input);
		if(detailPage == null)
			return StructuredSelection.EMPTY;
		return detailPage.getStructuredSelection();
	}

	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		DetailPage detailPage = getDetailPage(input);
		if(detailPage != null)
			detailPage.selectReveal(selection);
	}
	
	protected DetailPage getDetailPage(Object input)
	{
		if(input != null)
		{
			if(input instanceof IStructuredSelection)
				input = ((IStructuredSelection)input).getFirstElement();
			
			for(Iterator i = pageByType.entrySet().iterator(); i.hasNext();)
			{
				Map.Entry entry = (Map.Entry)i.next();
				if(((Class)entry.getKey()).isInstance(input))
					return (DetailPage)entry.getValue();
			}
		}
		
		return null;
	}
}
