/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.emf.common.util.EList;

/**
 * @author sleeloy
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public interface ILogSearchFilterUtil {

	/**
	 * Returns a list of events based on a filter criteria
	 * @param criteria the filter criteria used to create the list of events.
	 * @return the list of events.
	 */
	public EList filter(ILogFilterCriteria criteria);
	
	/**
	 * Returns the next index in the EList that matches the criteria.  
	 * 
	 * @param criteria the search criteria used to find the next record in the list
	 * @param logList the original filtered list 
	 * @param currentIndex the current index as the starting point to search for the next record
	 * @param direction the search direction.  true is foreward and false is backward.
	 * @return the index that matches the search criteria.  -1 if noting was found.
	 */
	public int search(ILogFilterCriteria criteria, EList logList, int currentIndex, boolean direction);
}
