/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.view;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

/**
 * Informs all registered listeners of graph node selection change
 * in the Frame
 * 
 * @author sveyrier
 *
 */
public class SDWidgetSelectionProvider implements ISelectionProvider{
	
	/**
	 * The listener list
	 */
	private ArrayList  listenerList		= null;
	
	/**
	 * The current selection
	 */
	protected ISelection currentSelection = null;
	
	
	protected SDWidgetSelectionProvider()
	{
		listenerList=new ArrayList();
	}

	/**
	 * Adds the given listener from the selection change listener list
	 * @param listener the listener to add
	 */
	public void addSelectionChangedListener(ISelectionChangedListener listener)
	{
		if (!listenerList.contains(listener))
			listenerList.add(listener);
	}
	
	/**
	 * Removes the given listener from the selection change listener list
	 * @param listener the listener to remove
	 */
	public void removeSelectionChangedListener(ISelectionChangedListener listener)
	{
		listenerList.remove(listener);
	}
	
	/**
	 * Changes the selection to the given selection and inform all listener
	 * @param selection the new current selection
	 */
	public void setSelection(ISelection selection)
	{
		currentSelection=selection;
		for (int i=0; i<listenerList.size();i++)
		{
			ISelectionChangedListener list = (ISelectionChangedListener)listenerList.get(i);
			list.selectionChanged(new SelectionChangedEvent(this,currentSelection));
		}
	}
	
	/**
	 * Returns the current selection
	 * @return the current selection
	 */
	public ISelection getSelection()
	{
		return currentSelection;
	}

}
