/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.util.IPagingList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class LogRecordSearch {

	private List cbeList;	
	private Object start = null;
	private int startIndex = -1;
	private RecordFilterSearchUtil recordFilterSearch = null;
	private LogFindCriteria criteria;
	private Query searchQuery = null;
	private QueryResult queryResult = null;
	private IFilterElement[] filters = null;
	private Map options = null;
	private List searchResult;
	private int cursorIndex = -1;
	private int searchIndex = -1;
	private boolean debug = false;
	private int type;

	public LogRecordSearch() {
		super();
		recordFilterSearch = new RecordFilterSearchUtil();
	}

	public void initialize(List cbeList, Object start, int type){
		this.cbeList = cbeList;
		this.start = start;
		this.type = type;
	    startIndex = -1; 	    
	    if(type==LogUIConstants.XMI){
	    	startIndex = lookForStartNodeIndex(start);
	    }
	}
	
	public void initStartNode(Object start, int type){
	    this.start = start;
		if(type==LogUIConstants.XMI){
	    	startIndex = lookForStartNodeIndex(start);
	    }
	}
	
	public Object search(SimpleSearchQuery query, LogFindCriteria newCriteria){

		Query newQuery = LogQueryBuilder.getMergedQuery(query, newCriteria);
		if(hasQueryChanged(newQuery)){
					
			startIndex = -1;
			searchQuery = newQuery;
			
			BusyIndicator.showWhile(Display.getDefault(), new Runnable(){	
				public void run(){
					queryResult = LogQueryBuilder.executeQuery(searchQuery, HierarchyResourceSetImpl.getInstance());
				}			
			});	
				
			ResultEntry resultEntry =(ResultEntry)queryResult.getResultEntries().get(0); 
			searchResult = resultEntry.getObjects();
			setCriteria(newCriteria);
		}else{
			if(hasDirectionChanged(newCriteria)){
				criteria.setForwardDirection(newCriteria.isForwardDirection());
			}
		}
		
		if(startIndex==-1){
			startIndex = lookForStartCursorIndex(newCriteria.isForwardDirection());
			if(criteria.isForwardDirection())	
				cursorIndex = startIndex-1;
			else
				cursorIndex = startIndex+1;
		}
		
		if(criteria.isForwardDirection()){
			if(cursorIndex<searchResult.size())
				cursorIndex++;
			if(debug){
				System.out.println("cursorIndex = " + cursorIndex);
				System.out.println("result size = " + searchResult.size());
			}
			if(cursorIndex<searchResult.size()){	
				start = getRecord();
				return start;
			}
		}else if(cursorIndex>=0){
			cursorIndex--;
			if(debug){
				System.out.println("cursorIndex = " + cursorIndex);
				System.out.println("result size = " + searchResult.size());
			}
			if(cursorIndex>=0){	
				start = getRecord();
				return start;
			}
		}		
		if(debug){
			System.out.println("cursorIndex = " + cursorIndex);
			System.out.println("result size = " + searchResult.size());
		}

		return null;
	}
	
	public int getType(){
		return type;
	}
	/**
	 * @param newCriteria
	 */
	private void setCriteria(LogFindCriteria newCriteria) {
		if(criteria==null){
			criteria = new LogFindCriteria();
			criteria.setFilterOptions(new HashMap());
		}
		
		criteria.setForwardDirection(newCriteria.isForwardDirection());
		int s = newCriteria.getFilters().length;
		IFilterElement[] filters = new IFilterElement[s];
		
		IFilterElement[] newFilters = newCriteria.getFilters();
		for(int i=0;i<s;i++){
			filters[i] = new FilterTableElement(newFilters[i].getAttribute(),newFilters[i].getOperator(),newFilters[i].getValue());
		}
		criteria.setFilters(filters);
		criteria.getFilterOptions().clear();
		if(newCriteria.getFilterOptions()!=null)
			criteria.getFilterOptions().putAll(newCriteria.getFilterOptions());
		
	}

	public Object search(IFilterElement[] filterTableElements, int direction,Object lastSelection){
        if(direction>0){
        	return searchDown(filterTableElements,lastSelection);
        }
        else{
        	return searchUp(filterTableElements,lastSelection);
        }	                        
	}
	
	private boolean hasDirectionChanged(LogFindCriteria newCriteria){
		return criteria.isForwardDirection()!=newCriteria.isForwardDirection();
	}
	
	private boolean hasQueryChanged(Query newQuery){
		
		if(searchQuery==null && newQuery!=null)
			return true;
		return !LogQueryBuilder.compare(searchQuery, newQuery);
	}
	
	private boolean hasSearchCriteriaChanged(LogFindCriteria newCriteria){
		
		if(criteria==null && newCriteria!=null)
			return true;		

		boolean filterHasChanged = false;
		IFilterElement[] newElements = newCriteria.getFilters();
		IFilterElement[] elements = criteria.getFilters();
		if(elements.length!=newElements.length)
			filterHasChanged=true;

		if(!filterHasChanged){
			for (int i = 0; i < elements.length; i++) {
				if(!elements[i].getAttribute().equals(newElements[i].getAttribute()) ||
				   !elements[i].getOperator().equals(newElements[i].getOperator())||
				   !elements[i].getValue().equals(newElements[i].getValue()))
					filterHasChanged=true;
			}
		}
		if(!filterHasChanged){
			if(newCriteria.getFilterOptions()!=null){
				if(!criteria.getFilterOptions().get(ILogFilterCriteria.OPTION_FILTER_SEV1).equals(newCriteria.getFilterOptions().get(ILogFilterCriteria.OPTION_FILTER_SEV1)) ||
					!criteria.getFilterOptions().get(ILogFilterCriteria.OPTION_FILTER_SEV2).equals(newCriteria.getFilterOptions().get(ILogFilterCriteria.OPTION_FILTER_SEV2)) ||
					!criteria.getFilterOptions().get(ILogFilterCriteria.OPTION_FILTER_SEV3).equals(newCriteria.getFilterOptions().get(ILogFilterCriteria.OPTION_FILTER_SEV3))){
					filterHasChanged=true;
				}
			}
		}
		if(filterHasChanged){
			cursorIndex = -1;
		}
		return filterHasChanged;
	}
	
	private int lookForStartNodeIndex(Object start){
		if (start==null) return 0; 

		for (int i=0;i<cbeList.size();i++)
		{
			if (cbeList.get(i) instanceof CBECommonBaseEvent
				&& start instanceof CBECommonBaseEvent
				&& ((CBECommonBaseEvent)cbeList.get(i)).getGlobalInstanceId().equals(((CBECommonBaseEvent)start).getGlobalInstanceId())
				) {
					return i;
				}
		}
		return 0;
	}
	
	private int lookForStartCursorIndex(final boolean direction){
		searchIndex = 0;
		if(searchResult!=null){
	   		BusyIndicator.showWhile(Display.getDefault(), new Runnable(){	
				public void run(){
					int s = searchResult.size();
					int index = -1;
					startIndex = ((IPagingList)cbeList).indexOf(start);
					if(startIndex==-1){
						startIndex = 0;
					}
					for(int i=0;i<s;i++){
						index = ((IPagingList)cbeList).indexOf(searchResult.get(i),startIndex);
						if(index>-1){
							if(direction){	
								searchIndex = i;
								break;
							}
							else{								
								searchIndex = i-1;
								break;
							}
						}
					}
					if(index<0 && !direction && s>0){
						searchIndex = s - 1;
					}

				}			
			});
		}
		return searchIndex;
	}
	

   private Object searchDown(IFilterElement[] filterTableElements,Object lastSelection){
   		if (lastSelection==start) startIndex++;
   		for (int i=startIndex;i<cbeList.size();i++)
   		{
   			if (recordFilterSearch.isAdvFilterApply((EObject)(cbeList.get(i)),filterTableElements)){
   				return cbeList.get(i);
   			}
   		}
   		return null;
   }

   private Object searchUp(IFilterElement[] filterTableElements,Object lastSelection){
	if (lastSelection==start) startIndex--;
	for (int i=startIndex;i>=0;i--)
	{
		if (recordFilterSearch.isAdvFilterApply((EObject)cbeList.get(i),filterTableElements)){
			return cbeList.get(i);
		}
	}
	return null;
   }
   
   private Object getRecord(){
	   	
   		BusyIndicator.showWhile(Display.getDefault(), new Runnable(){	
			public void run(){
				start = searchResult.get(cursorIndex);
			}			
		});	
		return start;

   }

}

