/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

/**
 * Decorator to {@link java.io.ObjectInputStream} that allows the definition
 * of a classloader to be used when recreating an object.
 * 
 * @author marcelop
 * @since 0.3.0
 */
public class ObjectInputStreamLoader
extends ObjectInputStream
{
	private ClassLoader classLoader;
	
	/**
	 * Constructor for ObjectInputStreamLoader
	 * @param inputStream
	 * @param classLoader
	 * @throws java.io.IOException
	 */
	public ObjectInputStreamLoader(InputStream inputStream, ClassLoader classLoader) 
	throws IOException
	{
		super(inputStream);
		this.classLoader = classLoader;
	}

	/**
	 * Constructor for ObjectInputStreamLoader
	 * @param classLoader
	 * @throws java.io.IOException
	 * @throws java.lang.SecurityException
	 */
	public ObjectInputStreamLoader(ClassLoader classLoader) throws 
	IOException, SecurityException
	{
		super();
		this.classLoader = classLoader;
	}
	
	/**
	 * @see java.io.ObjectInputStream#resolveClass(java.io.ObjectStreamClass)
	 */
	protected Class resolveClass(ObjectStreamClass v) 
	throws IOException, ClassNotFoundException
	{
		if(classLoader == null)
			return super.resolveClass(v);
		return Class.forName(v.getName(), false, classLoader);
	}	
}
