/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.util;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * Decorates a throwable given a RuntimeException behavior to it.  It can
 * be used to throw any throwable without adding any catch mechanism.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class RuntimeExceptionDecorator
extends RuntimeException
{
	private Throwable throwable;
	 
	/**
	 * Contructor for RuntimeExceptionDecorator
	 * @param throwable The throwable to be decorated. 
	 */
	public RuntimeExceptionDecorator(Throwable throwable)
	{
		this.throwable = throwable;
	}
			
	/**
	 * @see java.lang.Throwable#fillInStackTrace()
	 */
	public Throwable fillInStackTrace()
	{
		if(throwable == null)
			return super.fillInStackTrace();
			
		return throwable.fillInStackTrace();
	}

	/**
	 * @see java.lang.Throwable#getLocalizedMessage()
	 */
	public String getLocalizedMessage()
	{
		return throwable.getLocalizedMessage();
	}

	/**
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage()
	{
		return throwable.getMessage();
	}

	/**
	 * @see java.lang.Throwable#printStackTrace()
	 */
	public void printStackTrace()
	{
		throwable.printStackTrace();
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
	 */
	public void printStackTrace(PrintStream s)
	{
		throwable.printStackTrace(s);
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
	 */
	public void printStackTrace(PrintWriter s)
	{
		throwable.printStackTrace(s);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return throwable.toString();
	}
}