/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;


/**
 * @author slavescu
 */
public class CBEUtils {
    //~ Methods ------------------------------------------------------------------------------------

    public static double computeAdjustedCreationTime(CBECommonBaseEvent event) {
        double creationTime = event.getCreationTime();

        try {
            return creationTime + event.getAgent().getAgentProxy().getProcessProxy().getNode().getDeltaTime();
        } catch (Exception e) {
        }

        return creationTime;
    }
    
	/**
	 * Method formatCreationTime.
	 * @param element
	 * @return String
	 */
	public static String formatCreationTime(CBECommonBaseEvent event, SimpleDateFormat dateFormat) {

		String res="0";

		// if time is not specified, use "0"
		if (event.getCreationTime() != 0)
		{
			try {
				short value = event.getTimeZone();				
				double ct = computeAdjustedCreationTime(event);
				Double l2 = new Double(ct);
				
				res = dateFormat.format(new Date(((Double)l2).longValue()/1000 + value*60*1000));
				String microseconds = ""+(((Double)l2).longValue() % 1000000);
				res = res + "."+"000000".substring(0,6-microseconds.length()) + microseconds;
				res = res + (value>0?"+00":"-00").substring(0,3-(""+Math.abs(value/60)).length())+Math.abs(value/60);
				res = res + ":00".substring(0,3-(""+Math.abs(value%60)).length())+Math.abs(value%60);
				
			} catch (Exception e) {
			}
		}
		
		return res;

	}
    
}
