/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import java.util.Date;
import java.text.DateFormat;

import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IResourcePropertyConstants;

public class SymptomDBEditorOverviewPage extends EditorPage{

Label txtPath;
Label txtSize;
Label txtLocation;
Label txtTimeStamp;

public SymptomDBEditorOverviewPage(RASWidgetFactory factory){
	super(factory);
}

public void createContent(Composite parent){
	
	/*Composite content = this.factory.createComposite(parent, SWT.NULL);
	GridLayout pageLayout = new GridLayout();
	pageLayout.numColumns = 1;
	content.setLayout(pageLayout);
	content.setLayoutData(GridUtil.createFill());*/
		
	Composite sepHeader = this.factory.createCompositeSeparator(parent);
	
	Composite composite =  this.factory.createComposite(parent);
	GridLayout detailLayout = new GridLayout();
	detailLayout.numColumns = 2;
	composite.setLayout(detailLayout);
	composite.setLayoutData(GridUtil.createFill());
	
	Label lblPath = this.factory.createLabel(composite, SDbPlugin.getResourceString("STR_PATH_LABEL"), SWT.NONE);

	txtPath = this.factory.createLabel(composite, "", SWT.NONE);
	txtPath.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    txtPath.setFont(JFaceResources.getFont(JFaceResources.BANNER_FONT));
	
	Label lblLocation = this.factory.createLabel(composite, SDbPlugin.getResourceString("STR_LOCATION_LABEL"),SWT.NONE);

	txtLocation = this.factory.createLabel(composite, "", SWT.NONE);
	txtLocation.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	txtLocation.setFont(JFaceResources.getFont(JFaceResources.BANNER_FONT));
		
	Label lblSize = this.factory.createLabel(composite,SDbPlugin.getResourceString("STR_SIZE_LABEL"),SWT.NONE);
	txtSize = this.factory.createLabel(composite, "",SWT.NONE);
	txtSize.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	txtSize.setFont(JFaceResources.getFont(JFaceResources.BANNER_FONT));

	Label lblTimeStamp = this.factory.createLabel(composite,SDbPlugin.getResourceString("STR_TIMESTAMP_LABEL"),SWT.NONE);
	txtTimeStamp = this.factory.createLabel(composite, "",SWT.NONE);
	txtTimeStamp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	txtTimeStamp.setFont(JFaceResources.getFont(JFaceResources.BANNER_FONT));
	
    
    Composite dummy = this.factory.createComposite(parent);
    dummy.setLayoutData(GridUtil.createFill());
	
	Composite sep = this.factory.createCompositeSeparator(parent);


	Label lblComment = this.factory.createLabel(parent, SDbPlugin.getResourceString("STR_INFORMATION_LABEL"),SWT.WRAP);
	lblComment.setFont(JFaceResources.getFont(JFaceResources.BANNER_FONT));			
	
	factory.paintChildControlsFor(composite);

}

 public void init(SymptomDBEditor editor){
 	IFile file = editor.getFile();
 	if(file!=null){
 		FilePropertySource property = new FilePropertySource(file); 		
 		txtPath.setText((String)property.getPropertyValue(IResourcePropertyConstants.P_PATH_RES));
 		txtLocation.setText(file.getLocation().toOSString());
 		txtSize.setText((String)property.getPropertyValue(IResourcePropertyConstants.P_SIZE_RES) + " bytes"); 		
 		DateFormat df = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.MEDIUM);
 		
 		txtTimeStamp.setText(df.format(new Date(file.getLocation().toFile().lastModified())));
		org.eclipse.swt.graphics.Point p = getContent().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		((ScrolledComposite)editor.getControl(0)).setMinWidth(p.x); 	
		((ScrolledComposite)editor.getControl(0)).setMinHeight(p.y);	
 		
 	}
 }
}
