/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class adds rows in the Resource table for each top level object in the
 * resource.
 */
public class DetectResourceCommand extends DBCommand {
	protected Resource resource;

	/**
	 * Constructor for DetectResourceCommand.
	 * 
	 * @param helper
	 * @param map
	 * @param resource
	 */
	public DetectResourceCommand(JDBCHelper helper, DBMap map, Resource resource) {
		super(helper, map);
		this.resource = resource;
	}

	public Object execute() throws Exception {
		Table resourceTable = dbMap.getResourceTable();
		String query = "SELECT " + addQuotes(DBMapBuilder.URI_COLUMN_NAME) + " FROM " + addQuotes(resourceTable.getName()) + " WHERE " + addQuotes(DBMapBuilder.URI_COLUMN_NAME) + " = '" + resource.getURI().toString() + "'";
		Statement statement = helper.createStatement();
		ResultSet rs = helper.executeQuery(statement, query);
		boolean found = false;

		while (rs.next()) {
			found = true;
			break;
		}

		rs.close();
		statement.close();

		if (found)
			return Boolean.TRUE;
		else
			return Boolean.FALSE;
	}
} // DetectResourceCommand
