package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;

import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventException;
import org.eclipse.hyades.logging.events.cbe.util.EventMessages;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JNDI object factory for <code>EventFactory</code> objects.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * 
 * @see org.eclipse.hyades.logging.events.cbe.EventFactory
 */
public class EventFactoryObjectFactory implements ObjectFactory {

    /**
     * Classname for trace/log 
     */
    static final private String CLASS_NAME = EventFactoryObjectFactory.class.getName();

    /*
     * Public methods
     */

    /**
     * Simple constructor.
     */
    public EventFactoryObjectFactory() {
    }

    /**
     * @see javax.naming.spi.ObjectFactory#getObjectInstance(Object, Name, Context, Hashtable)
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {

        EventFactoryImpl result = null;

        if (obj instanceof Reference) {
            Reference ref = (Reference) obj;
            RefAddr refAddr = ref.get(EventFactoryImpl.CBE_INSTANCE_ADDRESS);
            if (refAddr instanceof BinaryRefAddr) {
                BinaryRefAddr binAddr = (BinaryRefAddr) refAddr;
                byte[] content = (byte[]) binAddr.getContent();
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(content);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    ContentHandler mh = null;
                    try {
                        mh = (ContentHandler) ois.readObject();
                    }
                    finally {
                        ois.close();
                        bis.close();
                    }
                    result = new EventFactoryImpl();
                    result.setContentHandler(mh);
                }
                catch (IOException e) {
                    Object params[] = new Object[] { name, e.getLocalizedMessage()};

                    throw new EventException(EventMessages.LOG_FAILED_TO_DESERIALIZE_CONTENT_HANDLER_EXC_, EventMessages.CLASS_NAME, params);
                }
            }
            else {
                // Reference address is not binary
                Object params[] = new Object[] { nameCtx.getNameInNamespace()};
                throw new EventException(EventMessages.LOG_INVALID_JNDI_REFERENCE_EXC_, EventMessages.CLASS_NAME, params);
            }
        }
        else {
            // Object is not a reference
            Object params[] = new Object[] { nameCtx.getNameInNamespace()};
            throw new EventException(EventMessages.LOG_INVALID_JNDI_REFERENCE_EXC_, EventMessages.CLASS_NAME, params);
        } // if obj is a Reference

        return result;
    }
}
