/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;

public class EnumerationGraph implements TextGraph {
	
	TimeZoomSlider xslider;
	ZoomSlider yslider;
	
	Color fg_col;
	int line_width = 1;

	int line_style = SWT.LINE_SOLID;
	
	public void setIndicatorSource(IndicatorSource isource) {
	}

	EnumerationGraphSource source;
	
	/**
	 * Graphs the reference lines for a pair of sliders
	 */
	public EnumerationGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col, EnumerationGraphSource source) {
		this.xslider = xslider;
		this.yslider = yslider;
		
		this.fg_col = col;
		
		this.source = source;
	}
	
	public BasicGraphSource getGraphSource() {
		return source;	
	}
	
	public double getXMin() {
		return source.getMin();		
	}

	public double getXMax() {
		return source.getMax();
	}


	public double getYMin() {
		return Double.NEGATIVE_INFINITY;		
	}

	public double getYMax() {
		return Double.POSITIVE_INFINITY;		
	}

	public TimeZoomSlider getXSlider() {
		return xslider;	
	}

	public ZoomSlider getYSlider() {
		return yslider;	
	}	
	public void setXSlider(TimeZoomSlider slider) {
		xslider = slider;
	}
	
	public void setYSlider(ZoomSlider slider) {
		yslider = slider;
	}	
	
	public void setForeground(Color col) {
		fg_col = col;
	}
	
	public Color getForeground() {
		return fg_col;
	}
	
	public void setLineWidth(int w) {
		line_width = w;
	}
	
	public int getLineWidth() {
		return line_width;
	}

	public void setLineStyle(int swt_line_style) {
		line_style = swt_line_style;
	}
	
	public int getLineStyle() {
		return line_style;	
	}
	
	public void setUseIndicator(boolean b) {
	}

	public void paintGraph(GC gc, int x, int y, int w, int h) {
		paintGraph(gc,x,y,w,h,0);
	}

	public int paintGraph(GC gc, int x, int y, int w, int h, int stroffset) {

		int yoffset = stroffset;
		int fheight = gc.getFontMetrics().getHeight();

//		int yoffset = index * gc.getFontMetrics().getHeight();
	
		gc.setForeground(fg_col);
		gc.setLineWidth(line_width);	
		gc.setLineStyle(line_style);

		Object prev = null;
		for (int i = x; i < x+w; i++) {
			double t = xslider.pixel2Value(i);
			if ( t >= source.getMin() && t <= source.getMax() ) {
				Object str = source.getValueAt(t);

				if (str != prev && !str.equals(prev)) {

					gc.setForeground(fg_col);

					gc.drawLine(i,y,i,y+h);

					gc.drawString(str.toString(),i+2,yoffset + y+1,true);

					gc.setForeground(yslider.getDisplay().getSystemColor(SWT.COLOR_BLACK));
					gc.drawString(str.toString(),i+1,yoffset + y,true);

					yoffset += fheight;
					
					if ((yoffset + fheight) > h) {
						yoffset = 0;
					}	
					
				}
				prev = str;
			}
		}

		return yoffset;
	}
	
	public void setStaticScaling(double mult) {
	}
	public double getStaticScaling() {
		return 1.0;
	} 

}