/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class MessagePanel extends Composite implements SelectionListener {

Object msg_lock = new Object();

	StringBuffer buffer = new StringBuffer();
	boolean cleared = false;
	
	boolean locked = false;
	

	Button lock;
	Button save;
	Button clear;
	Text msg_text;
		
	public MessagePanel(Composite parent, int style) {
		super(parent,style);
		init();
		initEventHandling();
	}
	
	private void init() {
		GridLayout layout = new GridLayout(2,false);
		layout.horizontalSpacing = 2;
		layout.verticalSpacing = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		GridData data = new GridData();

		setLayout(layout);

		lock = new Button(this,SWT.TOGGLE|SWT.CENTER);		
		lock.setImage(EditorPlugin.img.getImage(ImageManager.IMG_LOCK));
		
		msg_text = new Text(this,SWT.V_SCROLL | SWT.BORDER | SWT.MULTI | SWT.READ_ONLY | SWT.WRAP);
		
		save = new Button(this,SWT.PUSH|SWT.CENTER);
		save.setImage(EditorPlugin.img.getImage(ImageManager.IMG_SAVE));

//		clear = new Button(this,SWT.PUSH|SWT.CENTER);
//		clear.setImage(EditorPlugin.img.getImage(ImageManager.IMG_CLEAR));
		

		lock.setLayoutData(getButtonLayout());
		lock.setToolTipText(EditorPlugin.getString("LOCK_TOOLTIP"));

		save.setLayoutData(getButtonLayout());
		save.setToolTipText(EditorPlugin.getString("SAVE_TOOLTIP"));

//		clear.setLayoutData(getButtonLayout());
//		clear.setToolTipText(EditorPlugin.getString("CLEAR_TOOLTIP"));

		data = new GridData();		
		data.grabExcessHorizontalSpace = true;
		data.grabExcessVerticalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.FILL;
		data.verticalSpan = 4;
		msg_text.setLayoutData(data);
	}
	
	private void initEventHandling() {
		lock.addSelectionListener(this);	
		save.addSelectionListener(this);	
//		clear.addSelectionListener(this);	
	}
	
	private GridData getButtonLayout() {
		GridData data = new GridData();		
		data.grabExcessHorizontalSpace = false;
		data.grabExcessVerticalSpace = false;
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.FILL;
		data.widthHint = 21;
		data.heightHint = 21;
		return data;
	}
		
	public String getMsgText() {
		return msg_text.getText();		
	}
	
	public void setMsgText(String txt) {
		synchronized(msg_lock) {
			if (locked) {
				buffer.setLength(0);
				buffer.append(txt);
				cleared = true;
			} else {
				msg_text.setText(txt);
			}
		}
	}
	
	public void appendMsgText(String txt) {
		synchronized(msg_lock) {
			if (locked) {
				buffer.append(txt);
			} else {
				msg_text.append(txt);
			}
		}
	}
	
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}	 
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == lock) {
			
			synchronized(msg_lock) {
				locked = lock.getSelection();	
				
				if (locked == false) {
					if (cleared) {
						msg_text.setText(buffer.toString());	
					} else {
						msg_text.append(buffer.toString());	
					}
					cleared = false;
				} 
				buffer.setLength(0);
			}
			
		} else if (e.getSource() == save) {
			
			SaveAsDialog dialog = new SaveAsDialog(getShell());
			
			dialog.setTitle(EditorPlugin.getString("SAVE_LOG_TITLE"));
//throws a nullpointer exception :( - SWT bug
//			dialog.setMessage(EditorPlugin.getString("SAVE_LOG_MSG"));
			
			dialog.open();
			
			IPath result = dialog.getResult();
			
			if (result != null) {
					
				try {

					IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
					IFile file = root.getFile(result);					
//					IFile file = (IFile)result;

					ByteArrayInputStream bout = new ByteArrayInputStream(msg_text.getText().getBytes());
					
					try {
						file.setContents(bout,true,false,null);
					} catch (Exception xx) {						
						file.create(bout,true,null);
					}
					
				} catch (Throwable x) {
					MessageBox mbox = new MessageBox(getShell(),SWT.OK);
					mbox.setText(EditorPlugin.getString("SAVE_LOG_FAILED_TITLE"));
					mbox.setMessage(EditorPlugin.getString("SAVE_LOG_FAILED_MSG"));
					mbox.open();
					EditorPlugin.DBG.logVisibleError(x,EditorPlugin.getString("ERROR_SAVE_MESSAGE_LOG"),false);
					EditorPlugin.DBG.error("error saving message log",x);
				}
			}

//		} else if (e.getSource() == clear) {
//			
//			msg_text.setText("");
//			
		}
	}

}