/*``````````````````````````````````````````````````````````````/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */

package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.*;
import java.net.*;

/**
 * @author dmorris
 * modified by:  mddunn 11/17/2003 for Hyades-O 1.2
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ClientSideReaderSOCKS extends ClientSideReader {
	
	public static final String ERROR_SSL_REQUEST_MADE = "-1"; //this is an error until SSL is supported
	public static final String ERROR_NO_TESTKEYS = "-2"; //this is an error until SSL is supported
	static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
	//static int iConn = 0;
	static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");
	
	ClientSideReaderSOCKS(PeekSocket client, PacketWriter packetWriter, String keyFile){
		super(client,packetWriter, keyFile);
	
	}
/*	synchronized static int getNextConnection(){
		iConn++;
		return iConn;
	}
*/	
	public void run(){
		
		int bytes_read = 0;
		boolean socks_OK = false;
		String strReturn = null;
		boolean wroteOnePacket = false;
		//byte[] tmpBuff = {21,3,0,0,2,1,0};
		// Unexpected message
		byte[] tmpBuff = {21,3,0,0,2,2,10};
		 
		if (isSSLClassAvailable == -1)	{	
			isSSLClassAvailable = findSSLClass();
			if (isSSLClassAvailable == 1) {
				foundTestKeys = checkForTestKeys();
			}
		}
		this.setName("ClientSideReaderSOCKS-"+"Conn:"+ iConnection);
		try{
			
			byte[] buffer = new byte[client.getReceiveBufferSize()];
			socks_OK = processSocksRequest();
			if (socks_OK) {
				// TODO check for SSL Connection first before read
				bSecure = checkSSLByte();
				if (bSecure) {
					if (isSSLClassAvailable == 1)	{
						if (foundTestKeys) {
							SSLCheckClass thisSSLCheck = new SSLCheckClass(this, keyFile);
							thisSSLCheck.makeSecureConnection();
						}
						else  {
							// send message to UI 
							packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_NO_TESTKEYS);
							return;
						}
					}
					else {
						// send message to UI 
						packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_SSL_REQUEST_MADE);
						return;
					}
				}
				else 
					strReturn = makeRegularConnection();
				while ((bytes_read = from_client.read(buffer)) != -1){
					yield();
					bNoPrintToServer = false;
					int index = 0;
					String str = new String(buffer, 0, bytes_read);
					wroteOnePacket = true;
					
					if (bSecure){
						//packetWriter.writePacket(bSecure, true, iConnection, buffer, bytes_read);
						packetWriter.writePacket(bSecure, true, connectionNumber, buffer, bytes_read);
						if (!bNoPrintToServer){
							to_server.write(buffer, 0, bytes_read);
							to_server.flush();
						}
					}
					if (!bSecure){
						//packetWriter.writePacket(bSecure, true, iConnection, str.getBytes(), str.getBytes().length);
						packetWriter.writePacket(bSecure, true, connectionNumber, str.getBytes(), str.getBytes().length);
				
						if (!bNoPrintToServer && str.getBytes().length > 0){
							to_server.write(str.getBytes(), 0, str.getBytes().length);
							to_server.flush();
						}
					
					}
					
				}
			}
			
			
				if (httpServer != null){
				//if (! httpServer.isClosed())
				//	httpServer.close();
				// new mdd
				httpServer.setSoLinger(false,0);
				if (!wroteOnePacket) {
					if (! httpServer.isClosed()) {
						//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER A1 - CLOSED SERVERSIDE COnnection: " + iConnection);
						httpServer.close();
					}
				}
				else if (! httpServer.isOutputShutdown()){
					if (bSecure) {
						//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER A WRITING SSL CLOSE ALERT for COnnection: " + iConnection);
						to_server.write(tmpBuff, 0, 7);
						to_server.flush();
					} else {
						httpServer.shutdownOutput();
						//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER A - SHUTDOWN SERVERSIDE OUTPUT for COnnection: " + iConnection);
					}
				}
				//	mdd tell Server reader we are closed
				// MAY NEED serverReader.setClosedByClient();
			}

			yield();
			//packetWriter.writeCloseConnectionInfo(iConnection);

		}
		catch (Exception e) {
			boolean mustWriteClose = false;
			// mdd add check 
			//if COMMENTED OUT (!httpServer.isClosed()){
			//	mustWriteClose = true;
			//}
			//packetWriter.writeRecorderMessage(1, "JUST CAUGHT AN EXCEPTION In ClientSideReader connection " + iConnection + " Exception: " +e.getLocalizedMessage() );
				
			try {
				if (httpServer != null) {
					//if (!httpServer.isClosed())
					//	httpServer.close();
					if (!wroteOnePacket) {
						if (! httpServer.isClosed()) {
							//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER B1 - CLOSED SERVERSIDE COnnection: " + iConnection);
							httpServer.close();
						}
					} else 	if (!httpServer.isOutputShutdown()){
						if (bSecure) {
							//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER B WRITING SSL CLOSE ALERT for COnnection: " + iConnection);
							to_server.write(tmpBuff, 0, 7);
							to_server.flush();
						} else {
							httpServer.shutdownOutput();
							//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER B - SHUTDOWN SERVERSIDE OUTPUT for COnnection: " + iConnection);
						}
					}
					// mdd tell Server reader we are closed	
					// add check for null 032204
					//if (serverReader != null)	
						// MAT NEED serverReader.setClosedByClient();
				}
				
				yield();
				// force interrupt by nulling the buffer SSR is reading mdd
				//serverReader.interrupt();
				//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER NULL BUFFER FORCE INTERRUPT for COnnection: " + iConnection);
				serverReader.ssrBuffer = null;
				
			}
			catch (IOException ioe){
				String mess = ioe.getMessage();
				// no record for the following exceptions, they are expected
				
				if (mess.indexOf("Stream closed") < 0 && mess.indexOf("Socket closed") < 0 &&
				    mess.indexOf("JVM_recv in socket input") <0 && mess.indexOf("onnection closed")<0
				    && mess.indexOf("socket closed")<0 && mess.indexOf("onnection reset") < 0
					&& mess.indexOf("Socket is closed") <0) {
						packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + iConnection + " : " + e.getLocalizedMessage());
					}
			}
			//if (mustWriteClose)
				//packetWriter.writeCloseConnectionInfo(iConnection);
		}
		//packetWriter.writeRecorderMessage(1, "IN CLIENTSIDEREADER LEAVING RUN METHOD for COnnection: " + iConnection);
	}
	

	private boolean processSocksRequest() {
		boolean returnCode = false;
		int bytes_read = 0;
		int destPort = 0;
		int socksVersion = 0;
		int socksCommand = 0;
		String inetAddrStr = "";
		byte newInetAddress[] = new byte[4];
		int tmpInt = 0;
		InetAddress newAddr = null;
		
		// first read the entire socks header
		try {
			byte[] buffer = new byte[client.getReceiveBufferSize()];
			bytes_read = from_client.read(buffer);
			if (bytes_read < 8){
				// we have an error, must have at least 8 bytes
				returnCode = false;
			}
			else {
				int i=0;
				// have socks header, now process it
				for (i = 0; i < 8; i++){
					Byte tmpByte = new Byte(buffer[i]);
					switch(i){
					case 0:
						socksVersion = tmpByte.intValue();
						break;
					case 1:
						socksCommand = tmpByte.intValue();
						break;
					case 2:
						int tmp = 0;
						tmp = tmpByte.intValue();
						if (tmp < 0)
							tmp = tmp+256;
						destPort = (tmp*256) ;
						break;
					case 3:
						int tmp2 = 0;
						tmp2 = tmpByte.intValue();
						if (tmp2 < 0)
							tmp2 += 256;
						destPort += tmp2;
						break;
					case 4:
					case 5:
					case 6:
					case 7:
						newInetAddress[i-4] = buffer[i];
						break;
					}	
				}
				// now must connect to IP address
				inetAddrStr = IP4ByteToString(newInetAddress);
				newAddr =  InetAddress.getByName(inetAddrStr);
				destServer = newAddr.getHostName();
				serverPort = destPort;
				httpServer = new Socket(newAddr, destPort);
				if (httpServer != null) {
					respondToClient(true);
					returnCode = true;
				}
				else {
					returnCode = false;
					// TODO write error msg to log 
					respondToClient(false);
					//packetWriter.writeRecorderMessage(1, "Error connecting to Server:" + destServer + " Port: "+serverPort);
				}					
			}
		}
		catch (Exception e) {
			//packetWriter.writeRecorderMessage(1, "Error Reading from Client" + " Connection: " + iConnection);
			
			try {
				client.close();
			}
			catch (IOException ioe){
				packetWriter.writeRecorderMessage(1, "Error closing Client" + ioe + " Connection: " + iConnection);
			}
			//packetWriter.writeCloseConnectionInfo(iConnection);
		}
		return returnCode;
	}
	private static String IP4ByteToString (byte myvar[]) {
		String strResult = "";		
		for (int i = 0; i < 4; i++) {
			if ((int)myvar[i] >= 0) {
				strResult += String.valueOf((int)myvar[i]);
			} else {
				strResult += String.valueOf(256 + (int)myvar[i]);
			}
			if (i < 3) {
				strResult += ".";
			}		
		}
		return strResult;
	}
	private void respondToClient(boolean flag) {
		byte[] reply_buff = new byte[8];
	
		reply_buff[0] = 0;
		if (flag == true){
			reply_buff[1] = 90;
		}
		else {
			reply_buff[1] = 91;
		}
		try {
			to_client.write(reply_buff,0, 8);
			to_client.flush();
		} catch (Exception e){
		}
	}

	private String makeRegularConnection( ){
		
		String strReturn = null;
		//int index;	
		//int port = 80;
		//String destStr = null;
		boolean bFoundMessage = false;	

		try{
			// Note : already have open port to server
			//httpServer = new Socket(destStr, port);
			packetWriter.writeOpenConnectionInfo(bSecure, iConnection, destServer, serverPort, client, httpServer, null, null);
						
			to_server = httpServer.getOutputStream();
			from_server = httpServer.getInputStream();
						
			serverReader = new ServerSideReader(client,
												httpServer,
												from_server,
												to_client,
												 packetWriter,
												 //iConnection,
												 connectionNumber,
												 bSecure,
												 httpServer.getReceiveBufferSize());
			serverReader.start();
	
		}
		catch (Exception e){
				//packetWriter.writeRecorderMessage(2, "exception in ClientSideReader : " + e + " Connection: " + iConnection);
				packetWriter.getAgentController().reportException(ClientSideReaderException,e);
				
				try {
					if (!client.isClosed()) {
						client.close();
					}
					strReturn = null;
				}
				catch (IOException ioe){
					packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + iConnection + ": "  + ioe);
					
				}
				//packetWriter.writeCloseConnectionInfo(iConnection);
		}
		return strReturn;					
	}
	public int findSSLClass() {
		int gotSSL = -1;

		try{
				Class cl = Class.forName("javax.net.ssl.SSLSocket");
				gotSSL = 1;
			}
			catch (ClassNotFoundException cnf){
				gotSSL = 0;			
			}
		return gotSSL;
	}
	boolean checkSSLByte() {
		boolean isSSL = false;
		int ssl_byte = 0;
		//TODO must mark beginning of buffer, read 1 byte and check if the
		// byte = 128 or 20 or 21 or 22 or 23
		// if so, must convert client to spysocket and server to SSLSocketFactory socket
		// and reset() the buffer to beginning 

		try {
			ssl_byte = client.peek();
		}
		catch (IOException e) {
			packetWriter.writeRecorderMessage(2, "exception checking for SSL Connection: " + iConnection + e);
	
		}
		// packetWriter.writeRecorderMessage(1, "ssl_byte is: " + ssl_byte );
		if ((ssl_byte == 128) || (ssl_byte == 20) || (ssl_byte == 21) 
				|| (ssl_byte == 22) || (ssl_byte == 23)) {
				
			isSSL = true;
			bSecure = true;
		}
		else {
			bSecure = false;
			isSSL = false;
		}
		return isSSL;
	}

}