/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class AssociatedEventImplTest
extends TestCase {
    private AssociatedEvent ase;

    public AssociatedEventImplTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ase = EventFactory.eINSTANCE.createAssociatedEvent();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAssociatedEventImpl() {
    }

    public void testEStaticClass() {
    }

    public void testGetAssociationEngine() {
        String string = this.ase.getAssociationEngine();
        Assert.assertNull((Object)string);
    }

    public void testSetAssociationEngine() {
        String string = "set_association_engine";
        String string2 = null;
        this.ase.setAssociationEngine(string);
        string2 = this.ase.getAssociationEngine();
        Assert.assertEquals((String)string, (String)string2);
        this.ase.setAssociationEngine(null);
        string2 = this.ase.getAssociationEngine();
        Assert.assertNull((Object)string2);
    }

    public void testGetResolvedEvents() {
        String string = "1234567812345678 8765432187654321 1234123412341234";
        String string2 = null;
        string2 = this.ase.getResolvedEvents();
        Assert.assertNull((Object)string2);
        this.ase.setResolvedEvents(string);
        string2 = this.ase.getResolvedEvents();
        Assert.assertEquals((String)string, (String)string2);
        this.ase.setResolvedEvents(null);
        string2 = this.ase.getResolvedEvents();
        Assert.assertNull((Object)string2);
    }

    public void testGetResolvedEventsAsArray() {
        String string = "1234567812345678 8765432187654321 1234123412341234";
        String[] stringArray = null;
        stringArray = this.ase.getResolvedEventsAsArray();
        Assert.assertEquals((int)0, (int)stringArray.length);
        this.ase.setResolvedEvents(string);
        stringArray = this.ase.getResolvedEventsAsArray();
        Assert.assertEquals((int)3, (int)stringArray.length);
        Assert.assertEquals((String)"1234567812345678", (String)stringArray[0]);
        Assert.assertEquals((String)"8765432187654321", (String)stringArray[1]);
        Assert.assertEquals((String)"1234123412341234", (String)stringArray[2]);
        this.ase.setResolvedEvents(null);
        stringArray = this.ase.getResolvedEventsAsArray();
        Assert.assertEquals((int)0, (int)stringArray.length);
    }

    public void testSetResolvedEvents() {
        String string = "1234567812345678 8765432187654321 1234123412341234";
        String string2 = null;
        this.ase.setResolvedEvents(string);
        string2 = this.ase.getResolvedEvents();
        Assert.assertEquals((String)string, (String)string2);
        this.ase.setResolvedEvents(null);
        string2 = this.ase.getResolvedEvents();
        Assert.assertNull((Object)string2);
    }

    public void testSetResolvedEventsAsArray() {
        String[] stringArray = new String[]{"1234567812345678", "8765432187654321", "1234123412341234"};
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = new String[]{"1234567812345678", "87654321 7654321", "1234123412341234"};
        String string = null;
        this.ase.setResolvedEventsAsArray(stringArray);
        string = this.ase.getResolvedEvents();
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((String)"1234567812345678 8765432187654321 1234123412341234", (String)string);
        this.ase.setResolvedEventsAsArray(stringArray2);
        String[] stringArray4 = this.ase.getResolvedEventsAsArray();
        Assert.assertEquals((int)0, (int)stringArray4.length);
        string = this.ase.getResolvedEvents();
        Assert.assertEquals((int)0, (int)string.length());
        try {
            this.ase.setResolvedEventsAsArray(stringArray3);
            Assert.fail((String)"passed in an array that contains a blank in one element");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ase.setResolvedEventsAsArray(null);
            Assert.fail((String)"passed in null rather than null array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetAssociationEngineInfo() {
        String string = "myName";
        String string2 = "myType";
        String string3 = "myId";
        AssociationEngine associationEngine = this.ase.getAssociationEngineInfo();
        Assert.assertNull((String)"testGetAssociationEngineInfo()", (Object)associationEngine);
        this.ase.setAssociationEngineInfo(string, string2, string3);
        associationEngine = this.ase.getAssociationEngineInfo();
        Assert.assertEquals((String)string, (String)associationEngine.getName());
        Assert.assertEquals((String)string2, (String)associationEngine.getType());
        Assert.assertEquals((String)string3, (String)associationEngine.getId());
        this.ase.setAssociationEngineInfo(null, null, null);
        associationEngine = this.ase.getAssociationEngineInfo();
        Assert.assertNotNull((Object)associationEngine);
        Assert.assertNull((Object)associationEngine.getName());
        Assert.assertNull((Object)associationEngine.getType());
        Assert.assertNull((Object)associationEngine.getId());
    }

    public void testBasicSetAssociationEngineInfo() {
    }

    public void testSetAssociationEngineInfoAssociationEngine() {
        String string = "myName";
        String string2 = "myType";
        String string3 = "myId";
        this.ase.setAssociationEngineInfo(string, string2, string3);
        AssociationEngine associationEngine = this.ase.getAssociationEngineInfo();
        Assert.assertEquals((String)string, (String)associationEngine.getName());
        Assert.assertEquals((String)string2, (String)associationEngine.getType());
        Assert.assertEquals((String)string3, (String)associationEngine.getId());
        this.ase.setAssociationEngineInfo("xxx", "yyy", "zzz");
        AssociationEngine associationEngine2 = this.ase.getAssociationEngineInfo();
        Assert.assertEquals((String)"xxx", (String)associationEngine2.getName());
        Assert.assertEquals((String)"yyy", (String)associationEngine2.getType());
        Assert.assertEquals((String)"zzz", (String)associationEngine2.getId());
        this.ase.setAssociationEngineInfo(associationEngine);
        AssociationEngine associationEngine3 = this.ase.getAssociationEngineInfo();
        Assert.assertEquals((String)string, (String)associationEngine3.getName());
        Assert.assertEquals((String)string2, (String)associationEngine3.getType());
        Assert.assertEquals((String)string3, (String)associationEngine3.getId());
    }

    public void testEInverseRemoveInternalEObjectintClassNotificationChain() {
    }

    public void testEGetEStructuralFeatureboolean() {
    }

    public void testESetEStructuralFeatureObject() {
    }

    public void testEUnsetEStructuralFeature() {
    }

    public void testEIsSetEStructuralFeature() {
    }

    public void testToString() {
        Assert.assertNotNull((String)"empty AssociatedEvent", (Object)this.ase.toString());
        this.ase = EventFactory.eINSTANCE.createAssociatedEvent();
        this.ase.setAssociationEngine("my associationEngine");
        this.ase.setResolvedEvents(Util.getAlphaString(35) + " " + Util.getAlphaString(50));
        Assert.assertNotNull((String)"Associated Event with some data filled in", (Object)this.ase.toString());
    }

    public void testEquals1() throws ValidationException {
        String string = "AE123456789012345678901234567890";
        String string2 = "BE123456789012345678901234567890";
        String string3 = "CE123456789012345678901234567890";
        String[] stringArray = new String[]{string, string2};
        String[] stringArray2 = new String[]{string2, string3};
        AssociatedEvent associatedEvent = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent.setAssociationEngine(Util.getAlphaString(32));
        associatedEvent.setResolvedEventsAsArray(stringArray);
        AssociatedEvent associatedEvent2 = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent2.setAssociationEngine(Util.getAlphaString(32));
        associatedEvent2.setResolvedEventsAsArray(stringArray2);
        associatedEvent.validate();
        associatedEvent2.validate();
        AssociatedEvent associatedEvent3 = (AssociatedEvent)Util.clone(associatedEvent);
        Assert.assertEquals((Object)associatedEvent, (Object)associatedEvent3);
        AssociatedEvent associatedEvent4 = (AssociatedEvent)Util.clone(associatedEvent2);
        Assert.assertEquals((Object)associatedEvent2, (Object)associatedEvent4);
        Assert.assertFalse((boolean)associatedEvent.equals(associatedEvent2));
    }

    public void testEquals2() throws ValidationException {
        String string = "AE123456789012345678901234567890";
        String string2 = "BE123456789012345678901234567890";
        String string3 = "CE123456789012345678901234567890";
        String[] stringArray = new String[]{string, string2};
        AssociatedEvent associatedEvent = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent.setResolvedEventsAsArray(stringArray);
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine.setName("engine test");
        associationEngine.setType("Type");
        associationEngine.setId("AE345678901234567890123456789012");
        associatedEvent.setAssociationEngineInfo(associationEngine);
        AssociatedEvent associatedEvent2 = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent2.setResolvedEventsAsArray(stringArray);
        AssociationEngine associationEngine2 = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine2.setName("engine test");
        associationEngine2.setType("Type");
        associationEngine2.setId("BE345678901234567890123456789012");
        associatedEvent2.setAssociationEngineInfo(associationEngine2);
        associatedEvent.validate();
        associatedEvent2.validate();
        AssociatedEvent associatedEvent3 = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent3.setResolvedEventsAsArray(stringArray);
        AssociationEngine associationEngine3 = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine3.setName("engine test");
        associationEngine3.setType("Type");
        associationEngine3.setId("AE345678901234567890123456789012");
        associatedEvent3.setAssociationEngineInfo(associationEngine3);
        Assert.assertEquals((Object)associatedEvent, (Object)associatedEvent3);
        AssociatedEvent associatedEvent4 = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent4.setResolvedEventsAsArray(stringArray);
        AssociationEngine associationEngine4 = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine4.setName("engine test");
        associationEngine4.setType("Type");
        associationEngine4.setId("BE345678901234567890123456789012");
        associatedEvent4.setAssociationEngineInfo(associationEngine4);
        Assert.assertEquals((Object)associatedEvent2, (Object)associatedEvent4);
        Assert.assertFalse((boolean)associatedEvent.equals(associatedEvent2));
    }

    public void testEquals3() throws ValidationException {
        String string = "AE123456789012345678901234567890";
        String string2 = "BE123456789012345678901234567890";
        String[] stringArray = new String[]{string, string2};
        AssociatedEvent associatedEvent = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent.setResolvedEventsAsArray(stringArray);
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine.setName("engine test");
        associationEngine.setType("Type");
        associationEngine.setId("AE345678901234567890123456789012");
        associatedEvent.setAssociationEngineInfo(associationEngine);
        associatedEvent.validate();
        AssociatedEvent associatedEvent2 = EventFactory.eINSTANCE.createAssociatedEvent();
        associatedEvent2.setResolvedEventsAsArray(stringArray);
        AssociationEngine associationEngine2 = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine2.setName("engine test");
        associationEngine2.setType("Type");
        associationEngine2.setId("AE345678901234567890123456789012");
        associatedEvent2.setAssociationEngineInfo(associationEngine2);
        associatedEvent.validate();
        associatedEvent2.validate();
        Assert.assertEquals((Object)associatedEvent, (Object)associatedEvent2);
    }

    public void testValidate() throws ValidationException {
        Util.assertMissingAttributes(this.ase, "all");
        this.ase.setResolvedEvents("EDE test");
        try {
            this.ase.validate();
            Assert.fail((String)("missing mutually exclusive attributes in " + this.ase.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0204E", validationException);
        }
        this.ase.setAssociationEngine("cid");
        try {
            this.ase.validate();
            Assert.fail((String)("invalid resolvedEvents for " + this.ase.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0206E", validationException);
        }
        this.ase.setResolvedEvents(Util.getAlphaString(32) + " " + Util.getAlphaString(64));
        try {
            this.ase.validate();
            Assert.fail((String)("invalid id for " + this.ase.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0208E", validationException);
        }
        this.ase.setAssociationEngine(Util.getAlphaString(32));
        this.ase.validate();
    }

    public void testValidate2() throws ValidationException {
        Util.assertMissingAttributes(this.ase, "this is an empty associatedEvent");
        this.ase.setResolvedEvents(Util.getAlphaString(32));
        try {
            this.ase.validate();
            Assert.fail((String)("missing mutually exclusive attributes in " + this.ase.getClass().getName()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0204E", validationException);
        }
        this.ase = EventFactory.eINSTANCE.createAssociatedEvent();
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine.setName("AEI name");
        associationEngine.setType("AEI type");
        associationEngine.setId(Util.getAlphaString(32));
        this.ase.setAssociationEngineInfo(associationEngine);
        Util.assertMissingAttributes(this.ase, "resolvedEvents");
        this.ase.setResolvedEvents(Util.getAlphaString(32) + " " + Util.getAlphaString(64));
        this.ase.validate();
    }

    public void testSetAssociationEngineInfoStringStringString() {
        String string = "myName";
        String string2 = "myType";
        String string3 = "myId";
        this.ase.setAssociationEngineInfo(string, string2, string3);
        AssociationEngine associationEngine = this.ase.getAssociationEngineInfo();
        Assert.assertEquals((String)string, (String)associationEngine.getName());
        Assert.assertEquals((String)string2, (String)associationEngine.getType());
        Assert.assertEquals((String)string3, (String)associationEngine.getId());
        this.ase.setAssociationEngineInfo(null, null, null);
        associationEngine = this.ase.getAssociationEngineInfo();
        Assert.assertNotNull((Object)associationEngine);
        Assert.assertNull((Object)associationEngine.getName());
        Assert.assertNull((Object)associationEngine.getType());
        Assert.assertNull((Object)associationEngine.getId());
    }
}

