/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;

public class EventPackageImplTest
extends TestCase {
    private EventFactory cfi;

    public EventPackageImplTest(String string) {
        super(string);
    }

    public void testCreateAssociationEngine() throws Exception {
        AssociationEngine associationEngine = this.cfi.createAssociationEngine();
        associationEngine.setId("A");
        associationEngine.setName("A");
        associationEngine.setType("A");
        Assert.assertTrue((boolean)(associationEngine.getId() instanceof String));
        Assert.assertTrue((boolean)(associationEngine.getName() instanceof String));
        Assert.assertTrue((boolean)(associationEngine.getType() instanceof String));
        this.testSerialization(associationEngine);
    }

    public void testCreateComponentIdentification() throws Exception {
        ComponentIdentification componentIdentification = this.cfi.createComponentIdentification();
        componentIdentification.setApplication("A");
        componentIdentification.setComponent("A");
        componentIdentification.setComponentIdType("A");
        componentIdentification.setExecutionEnvironment("A");
        componentIdentification.setInstanceId("A");
        componentIdentification.setLocation("A");
        componentIdentification.setLocationType("A");
        componentIdentification.setProcessId("A");
        componentIdentification.setSubComponent("A");
        componentIdentification.setThreadId("A");
        Assert.assertTrue((boolean)(componentIdentification.getApplication() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getComponent() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getComponentIdType() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getExecutionEnvironment() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getInstanceId() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getLocation() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getLocationType() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getProcessId() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getSubComponent() instanceof String));
        Assert.assertTrue((boolean)(componentIdentification.getThreadId() instanceof String));
        this.testSerialization(componentIdentification);
    }

    public void testCreateContextDataElement() throws Exception {
        ContextDataElement contextDataElement = this.cfi.createContextDataElement();
        ContextDataElement contextDataElement2 = this.cfi.createContextDataElement();
        contextDataElement.setContextId("A");
        contextDataElement.setContextValue("A");
        contextDataElement.setName("A");
        contextDataElement.setType("A");
        Assert.assertTrue((boolean)(contextDataElement.getContextId() instanceof String));
        Assert.assertTrue((boolean)(contextDataElement.getContextValue() instanceof String));
        Assert.assertTrue((boolean)(contextDataElement.getName() instanceof String));
        Assert.assertTrue((boolean)(contextDataElement.getType() instanceof String));
        this.testSerialization(contextDataElement);
    }

    public void testCreateExtendedDataElement() throws Exception {
        ExtendedDataElement extendedDataElement = this.cfi.createExtendedDataElement();
        ExtendedDataElement extendedDataElement2 = this.cfi.createExtendedDataElement();
        extendedDataElement.getChildren().add(extendedDataElement2);
        extendedDataElement.getValues().add("A");
        extendedDataElement.setHexValue("A");
        extendedDataElement.setName("A");
        extendedDataElement.setType("A");
        Assert.assertTrue((boolean)(extendedDataElement.getChildren().get(0) instanceof ExtendedDataElement));
        Assert.assertTrue((boolean)(extendedDataElement.getValues().get(0) instanceof String));
        Assert.assertTrue((boolean)(extendedDataElement.getHexValue() instanceof String));
        Assert.assertTrue((boolean)(extendedDataElement.getName() instanceof String));
        Assert.assertTrue((boolean)(extendedDataElement.getType() instanceof String));
        this.testSerialization(extendedDataElement);
    }

    public void testCreateAssociatedEvent() throws Exception {
        AssociatedEvent associatedEvent = this.cfi.createAssociatedEvent();
        AssociationEngine associationEngine = this.cfi.createAssociationEngine();
        associatedEvent.setAssociationEngine("A");
        associatedEvent.setResolvedEvents("A");
        Assert.assertTrue((boolean)(associatedEvent.getAssociationEngine() instanceof String));
        Assert.assertTrue((boolean)(associatedEvent.getResolvedEvents() instanceof String));
        this.testSerialization(associatedEvent);
    }

    public void testCreateMsgDataElement() throws Exception {
        MsgDataElement msgDataElement = this.cfi.createMsgDataElement();
        msgDataElement.setMsgCatalog("A");
        msgDataElement.setMsgCatalogId("A");
        msgDataElement.setMsgId("A");
        msgDataElement.setMsgLocale("A");
        MsgCatalogToken msgCatalogToken = this.cfi.createMsgCatalogToken();
        msgDataElement.getMsgCatalogTokens().add(msgCatalogToken);
        Assert.assertTrue((boolean)(msgDataElement.getMsgCatalog() instanceof String));
        Assert.assertTrue((boolean)(msgDataElement.getMsgCatalogId() instanceof String));
        Assert.assertTrue((boolean)(msgDataElement.getMsgId() instanceof String));
        Assert.assertTrue((boolean)(msgDataElement.getMsgLocale() instanceof String));
        Assert.assertTrue((boolean)(msgDataElement.getMsgCatalogTokens().get(0) instanceof MsgCatalogToken));
        this.testSerialization(msgDataElement);
    }

    public void testCreateCommonBaseEvent() throws Exception {
        CommonBaseEvent commonBaseEvent = this.cfi.createCommonBaseEvent();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("Id01234567890123");
        ComponentIdentification componentIdentification = this.cfi.createComponentIdentification();
        commonBaseEvent.setReporterComponentId(componentIdentification);
        componentIdentification = this.cfi.createComponentIdentification();
        commonBaseEvent.setSourceComponentId(componentIdentification);
        Assert.assertTrue((boolean)(commonBaseEvent.getCreationTime() instanceof String));
        Assert.assertTrue((boolean)(commonBaseEvent.getGlobalInstanceId() instanceof String));
        Assert.assertTrue((boolean)(commonBaseEvent.getReporterComponentId() instanceof ComponentIdentification));
        Assert.assertTrue((boolean)(commonBaseEvent.getSourceComponentId() instanceof ComponentIdentification));
        this.testSerialization(commonBaseEvent);
    }

    protected void setUp() {
        this.cfi = EventFactory.eINSTANCE;
    }

    protected void tearDown() throws Exception {
    }

    private void testSerialization(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
    }
}

