/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class SituationImplTest
extends TestCase {
    Situation sit = null;

    public SituationImplTest(String string) {
        super(string);
    }

    public void testSetAvailableSituation() {
        String string = "r";
        String string2 = "availability";
        String string3 = "operation";
        String string4 = "processing";
        this.sit.setAvailableSituation(string, string2, string3, string4);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("AvailableSituation"));
        AvailableSituation availableSituation = (AvailableSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)availableSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)availableSituation.getAvailabilityDisposition().equals(string2));
        Assert.assertTrue((boolean)availableSituation.getOperationDisposition().equals(string3));
        Assert.assertTrue((boolean)availableSituation.getProcessingDisposition().equals(string4));
    }

    public void testSetCategoryName() {
        this.sit.setCategoryName("CreateSituation");
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("CreateSituation"));
        this.sit.setCategoryName("DestroySituation");
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("DestroySituation"));
    }

    public void testGetCategoryName() {
        Assert.assertTrue((this.sit.getCategoryName() == null ? 1 : 0) != 0);
        this.sit.setCategoryName("ConnectSituation");
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("ConnectSituation"));
    }

    public void testSetConfigureSituation() {
        String string = "r";
        String string2 = "success";
        this.sit.setConfigureSituation(string, string2);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("ConfigureSituation"));
        ConfigureSituation configureSituation = (ConfigureSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)configureSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)configureSituation.getSuccessDisposition().equals(string2));
    }

    public void testSetConnectSituation() {
        String string = "r";
        String string2 = "situation";
        String string3 = "success";
        this.sit.setConnectSituation(string, string2, string3);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("ConnectSituation"));
        ConnectSituation connectSituation = (ConnectSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)connectSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)connectSituation.getSituationDisposition().equals(string2));
        Assert.assertTrue((boolean)connectSituation.getSuccessDisposition().equals(string3));
    }

    public void testSetCreateSituation() {
        String string = "r";
        String string2 = "success";
        this.sit.setCreateSituation(string, string2);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("CreateSituation"));
        CreateSituation createSituation = (CreateSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)createSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)createSituation.getSuccessDisposition().equals(string2));
    }

    public void testSetDependencySituation() {
        String string = "r";
        String string2 = "dependency";
        this.sit.setDependencySituation(string, string2);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("DependencySituation"));
        DependencySituation dependencySituation = (DependencySituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)dependencySituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)dependencySituation.getDependencyDisposition().equals(string2));
    }

    public void testSetDestroySituation() {
        String string = "r";
        String string2 = "success";
        this.sit.setDestroySituation(string, string2);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("DestroySituation"));
        DestroySituation destroySituation = (DestroySituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)destroySituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)destroySituation.getSuccessDisposition().equals(string2));
    }

    public void testSetFeatureSituation() {
        String string = "r";
        String string2 = "feature";
        this.sit.setFeatureSituation(string, string2);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("FeatureSituation"));
        FeatureSituation featureSituation = (FeatureSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)featureSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)featureSituation.getFeatureDisposition().equals(string2));
    }

    public void testSetOtherSituation() {
        String string = "r";
        String string2 = "any";
        this.sit.setOtherSituation(string, string2);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("OtherSituation"));
        OtherSituation otherSituation = (OtherSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)otherSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)otherSituation.getAny().equals(string2));
    }

    public void testSetReportSituation() {
        String string = "r";
        String string2 = "report";
        this.sit.setReportSituation(string, string2);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("ReportSituation"));
        ReportSituation reportSituation = (ReportSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)reportSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)reportSituation.getReportCategory().equals(string2));
    }

    public void testSetRequestSituation() {
        String string = "r";
        String string2 = "situation";
        String string3 = "success";
        this.sit.setRequestSituation(string, string2, string3);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("RequestSituation"));
        RequestSituation requestSituation = (RequestSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)requestSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)requestSituation.getSituationQualifier().equals(string2));
        Assert.assertTrue((boolean)requestSituation.getSuccessDisposition().equals(string3));
    }

    public void testSetSituationType() {
        RequestSituation requestSituation = EventFactory.eINSTANCE.createRequestSituation();
        this.sit.setSituationType(requestSituation);
        Assert.assertTrue((this.sit.getSituationType() == requestSituation ? 1 : 0) != 0);
        DependencySituation dependencySituation = EventFactory.eINSTANCE.createDependencySituation();
        this.sit.setSituationType(dependencySituation);
        Assert.assertTrue((this.sit.getSituationType() == dependencySituation ? 1 : 0) != 0);
    }

    public void testGetSituationType() {
        Assert.assertTrue((this.sit.getSituationType() == null ? 1 : 0) != 0);
        StopSituation stopSituation = EventFactory.eINSTANCE.createStopSituation();
        this.sit.setSituationType(stopSituation);
        Assert.assertTrue((this.sit.getSituationType() == stopSituation ? 1 : 0) != 0);
    }

    public void testSetStartSituation() {
        String string = "r";
        String string2 = "situation";
        String string3 = "success";
        this.sit.setStartSituation(string, string2, string3);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("StartSituation"));
        StartSituation startSituation = (StartSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)startSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)startSituation.getSituationQualifier().equals(string2));
        Assert.assertTrue((boolean)startSituation.getSuccessDisposition().equals(string3));
    }

    public void testSetStopSituation() {
        String string = "r";
        String string2 = "situation";
        String string3 = "success";
        this.sit.setStopSituation(string, string2, string3);
        Assert.assertTrue((boolean)this.sit.getCategoryName().equals("StopSituation"));
        StopSituation stopSituation = (StopSituation)this.sit.getSituationType();
        Assert.assertTrue((boolean)stopSituation.getReasoningScope().equals(string));
        Assert.assertTrue((boolean)stopSituation.getSituationQualifier().equals(string2));
        Assert.assertTrue((boolean)stopSituation.getSuccessDisposition().equals(string3));
    }

    public void testToString() {
        Assert.assertNotNull((Object)this.sit.toString());
    }

    public void testSerialization() {
        Util.testEObjectSerialization(this.sit);
    }

    public void testEquals() throws ValidationException {
        Situation situation = EventFactory.eINSTANCE.createSituation();
        this.sit.setStopSituation("reasoning", "UNSUCCESSFUL", "PAUSE INITIATED");
        this.sit.getSituationType().setReasoningScope("EXTERNAL");
        this.sit.validate();
        situation = (Situation)Util.clone(this.sit);
        Assert.assertEquals((Object)this.sit, (Object)situation);
        situation.setCategoryName("ConnectSituation");
        Assert.assertFalse((boolean)this.sit.equals(situation));
        situation.setCategoryName("StopSituation");
        Assert.assertEquals((Object)this.sit, (Object)situation);
        this.sit.setStopSituation("r2", "SUCCESSFUL", "PAUSE INITIATED");
        Assert.assertFalse((boolean)this.sit.equals(situation));
        this.sit = EventFactory.eINSTANCE.createSituation();
        situation = EventFactory.eINSTANCE.createSituation();
        this.sit.setCategoryName("StopSituation");
        this.sit.setStopSituation("r", "UNSUCCESSFUL", "PAUSE INITIATED");
        situation.setCategoryName("StopSituation");
        Assert.assertFalse((boolean)this.sit.equals(situation));
    }

    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(this.sit, "all");
        this.sit.setStopSituation("r", "UNSUCCESSFUL", "PAUSE INITIATED");
        this.sit.setCategoryName("StopSituation");
        this.sit.validate();
        this.sit.setCategoryName(null);
        Util.assertMissingAttributes(this.sit, "categoryName");
        this.sit = EventFactory.eINSTANCE.createSituation();
        this.sit.setCategoryName("StopSituation");
        Util.assertMissingAttributes(this.sit, "situationType");
    }

    public void testValidationInvalidData() {
        this.sit.setStopSituation("r", "UNSUCCESSFUL", "PAUSE INITIATED");
        this.sit.setCategoryName("xyz");
        try {
            this.sit.validate();
            Assert.fail((String)"invalid categoryName");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0199E", validationException);
        }
    }

    public void testCategoryTypeValidation() {
        this.sit.setAvailableSituation("r", "a", "b", "c");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setConfigureSituation("a", "b");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setConnectSituation("a", "b", "c");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setCreateSituation("b", "c");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setDependencySituation("a", "b");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setDestroySituation("a", "b");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setFeatureSituation("a", "b");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setOtherSituation("a", "b");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setReportSituation("a", "b");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setRequestSituation("a", "b", "c");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setStartSituation("a", "b", "c");
        this.sit.setCategoryName("StopSituation");
        this.assertCategory(this.sit);
        this.sit.setStartSituation("a", "b", "f");
        this.sit.setCategoryName("AvailableSituation");
        this.assertCategory(this.sit);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sit = EventFactory.eINSTANCE.createSituation();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void assertCategory(Situation situation) {
        try {
            situation.validate();
            Assert.fail((String)("Category " + situation.getCategoryName() + " does not match the situation type " + situation.getSituationType()));
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0211E", validationException);
        }
    }
}

